/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.orient;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.transaction.OrientOperations;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.internal.orient.BrowseNodeEntityAdapter;
import org.sonatype.nexus.repository.browse.internal.orient.OrientBrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowseListItem;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowseNodeComparator;
import org.sonatype.nexus.repository.browse.node.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.browse.node.BrowseNodeFilter;
import org.sonatype.nexus.repository.browse.node.BrowseNodeIdentity;
import org.sonatype.nexus.repository.browse.node.BrowseNodeQueryService;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.SelectorSqlBuilder;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Priority(value=0x7FFFFFFF)
@Named
public class OrientBrowseNodeStore
extends StateGuardLifecycleSupport
implements BrowseNodeQueryService {
    private final Provider<DatabaseInstance> databaseInstance;
    private final BrowseNodeEntityAdapter entityAdapter;
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;
    private final Map<String, BrowseNodeFilter> browseNodeFilters;
    private final Map<String, BrowseNodeIdentity> browseNodeIdentities;
    private final Map<String, BrowseNodeComparator> browseNodeComparators;
    private final BrowseNodeComparator defaultBrowseNodeComparator;
    private final int deletePageSize;
    private static final EscapeHelper escapeHelper = new EscapeHelper();

    @Inject
    public OrientBrowseNodeStore(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstance, BrowseNodeEntityAdapter entityAdapter, SecurityHelper securityHelper, SelectorManager selectorManager, BrowseNodeConfiguration configuration, Map<String, BrowseNodeFilter> browseNodeFilters, Map<String, BrowseNodeIdentity> browseNodeIdentities, Map<String, BrowseNodeComparator> browseNodeComparators) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (BrowseNodeEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.browseNodeFilters = (Map)Preconditions.checkNotNull(browseNodeFilters);
        this.browseNodeIdentities = (Map)Preconditions.checkNotNull(browseNodeIdentities);
        this.browseNodeComparators = (Map)Preconditions.checkNotNull(browseNodeComparators);
        this.deletePageSize = configuration.getDeletePageSize();
        this.defaultBrowseNodeComparator = (BrowseNodeComparator)Preconditions.checkNotNull((Object)browseNodeComparators.get("default"));
    }

    @Guarded(by={"STARTED"})
    public void createComponentNode(String repositoryName, String format, List<BrowsePath> paths, Component component) {
        ((OrientOperations)OrientTransactional.inTxRetry(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordDuplicatedException.class})).run(db -> this.entityAdapter.createComponentNode(db, repositoryName, format, paths, component));
    }

    @Guarded(by={"STARTED"})
    public void createAssetNode(String repositoryName, String format, List<BrowsePath> paths, Asset asset) {
        ((OrientOperations)OrientTransactional.inTxRetry(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordDuplicatedException.class})).run(db -> this.entityAdapter.createAssetNode(db, repositoryName, format, paths, asset));
    }

    @Guarded(by={"STARTED"})
    public boolean assetNodeExists(Asset asset) {
        EntityId assetId = EntityHelper.id((Entity)asset);
        return (Boolean)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.assetNodeExists(db, assetId));
    }

    @Guarded(by={"STARTED"})
    public void deleteComponentNode(Component component) {
        EntityId componentId = EntityHelper.id((Entity)component);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteComponentNode(db, componentId));
    }

    @Guarded(by={"STARTED"})
    public void deleteAssetNode(Asset asset) {
        EntityId assetId = EntityHelper.id((Entity)asset);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteAssetNode(db, assetId));
    }

    @Guarded(by={"STARTED"})
    public void deleteByRepository(String repositoryName) {
        int deletedCount;
        this.log.debug("Deleting all browse nodes for repository {}", (Object)repositoryName);
        ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
        do {
            deletedCount = (Integer)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.deleteByRepository(db, repositoryName, this.deletePageSize));
            progressLogger.info("Deleted {} browse nodes for repository {} in {}", new Object[]{deletedCount, repositoryName, progressLogger.getElapsed()});
        } while (deletedCount == this.deletePageSize);
        progressLogger.flush();
        this.log.debug("All browse nodes deleted for repository {} in {}", (Object)repositoryName, (Object)progressLogger.getElapsed());
    }

    @Guarded(by={"STARTED"})
    public Iterable<BrowseNode> getByPath(Repository repository, List<String> path, int maxNodes) {
        List<Object> results;
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        List selectors = Collections.emptyList();
        if (!this.hasBrowsePermission(repositoryName, format) && (selectors = this.selectorManager.browseActive(Arrays.asList(repositoryName), Arrays.asList(format))).isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> filterParameters = new HashMap<String, Object>();
        String assetFilter = this.buildAssetFilter(repository, selectors, filterParameters);
        BrowseNodeFilter filter = this.browseNodeFilters.getOrDefault(format, (node, name) -> true);
        if (repository.getType() instanceof GroupType) {
            BrowseNodeIdentity identity = this.browseNodeIdentities.getOrDefault(format, BrowseNode::getName);
            Equivalence browseNodeEquivalence = Equivalence.equals().onResultOf(arg_0 -> ((BrowseNodeIdentity)identity).identity(arg_0));
            results = OrientBrowseNodeStore.members(repository).map(m -> this.getByPath(m.getName(), path, maxNodes, assetFilter, filterParameters)).flatMap(Collection::stream).map(arg_0 -> ((Equivalence)browseNodeEquivalence).wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).filter(node -> filter.test((Object)node, (Object)repositoryName.equals(node.getRepositoryName()))).limit(maxNodes).collect(Collectors.toList());
        } else {
            results = this.getByPath(repository.getName(), path, maxNodes, assetFilter, filterParameters).stream().filter(node -> filter.test((Object)node, (Object)repositoryName.equals(node.getRepositoryName()))).collect(Collectors.toList());
        }
        results.sort(this.getBrowseNodeComparator(format));
        return results;
    }

    private static Stream<Repository> members(Repository repository) {
        return ((GroupFacet)repository.facet(GroupFacet.class)).leafMembers().stream();
    }

    private List<OrientBrowseNode> getByPath(String repositoryName, List<String> path, int maxNodes, @Nullable String assetFilter, @Nullable Map<String, Object> filterParameters) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getByPath(db, repositoryName, path, maxNodes, assetFilter, filterParameters));
    }

    private String buildAssetFilter(Repository repository, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        StringBuilder filterBuilder = new StringBuilder();
        if (!selectors.isEmpty()) {
            this.appendContentAuthFilter(filterBuilder, repository, selectors, filterParameters);
        }
        return filterBuilder.toString();
    }

    private boolean hasBrowsePermission(String repositoryName, String format) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(format, repositoryName, new String[]{"browse"})});
    }

    private void appendContentAuthFilter(StringBuilder filterBuilder, Repository repository, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        if (selectors.size() > 1) {
            filterBuilder.append('(');
        }
        SelectorSqlBuilder sqlBuilder = new SelectorSqlBuilder().propertyAlias("path", "path").propertyAlias("format", "format").parameterPrefix(":").propertyPrefix("asset_id.attributes." + format + ".");
        int cselCount = 0;
        for (SelectorConfiguration selector : selectors) {
            if (!"csel".equals(selector.getType())) continue;
            try {
                try {
                    sqlBuilder.parameterNamePrefix("s" + cselCount + "p");
                    this.selectorManager.toSql(selector, sqlBuilder);
                    if (cselCount > 0) {
                        filterBuilder.append(" or ");
                    }
                    filterBuilder.append('(').append(sqlBuilder.getQueryString()).append(')');
                    filterParameters.putAll(sqlBuilder.getQueryParameters());
                    ++cselCount;
                }
                catch (SelectorEvaluationException e) {
                    this.log.warn("Problem evaluating selector {} as SQL", (Object)selector.getName(), (Object)e);
                    sqlBuilder.clearQueryString();
                    continue;
                }
            }
            catch (Throwable throwable) {
                sqlBuilder.clearQueryString();
                throw throwable;
            }
            sqlBuilder.clearQueryString();
        }
        if (selectors.size() > cselCount) {
            if (cselCount > 0) {
                filterBuilder.append(" or ");
            }
            filterBuilder.append(String.format("contentAuth(@this.%s, @this.%s, :%s, true) = true", "path", "format", "authz_repository_name"));
            filterParameters.put("authz_repository_name", repositoryName);
        }
        if (selectors.size() > 1) {
            filterBuilder.append(')');
        }
    }

    private Comparator<BrowseNode> getBrowseNodeComparator(String format) {
        return (Comparator)this.browseNodeComparators.getOrDefault(format, this.defaultBrowseNodeComparator);
    }

    public List<BrowseListItem> toListItems(Repository repository, Iterable<BrowseNode> nodes) {
        ArrayList<BrowseListItem> listItems = new ArrayList<BrowseListItem>();
        if (nodes != null) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            for (BrowseNode browseNode : nodes) {
                String listItemPath;
                String size = null;
                String lastModified = null;
                if (browseNode.isLeaf()) {
                    Asset asset = this.getAssetById(repository, browseNode.getAssetId());
                    if (asset == null) {
                        this.log.error("Could not find expected asset (id): {} ({}) in repository: {}", new Object[]{browseNode.getPath(), browseNode.getAssetId(), repository.getName()});
                        continue;
                    }
                    size = String.valueOf(asset.size());
                    lastModified = Optional.ofNullable(asset.blobUpdated()).map(dateTime -> format.format(dateTime.toDate())).orElse("");
                    listItemPath = this.getListItemPath(repository, browseNode, asset);
                } else {
                    listItemPath = this.getListItemPath(repository, browseNode, null);
                }
                listItems.add(new BrowseListItem(listItemPath, browseNode.getName(), !browseNode.isLeaf(), lastModified, size, ""));
            }
        }
        return listItems;
    }

    private Asset getAssetById(Repository repository, EntityId assetId) {
        Optional optionalGroupFacet = repository.optionalFacet(GroupFacet.class);
        List members = optionalGroupFacet.isPresent() ? ((GroupFacet)optionalGroupFacet.get()).allMembers() : Collections.singletonList(repository);
        return (Asset)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset candidate = tx.findAsset(assetId);
            if (candidate != null) {
                ODocument bucketRecord = (ODocument)((AttachedEntityId)candidate.bucketId()).getIdentity().getRecord();
                String asssetBucketRepositoryName = (String)bucketRecord.field("repository_name");
                if (members.stream().anyMatch(repo -> repo.getName().equals(asssetBucketRepositoryName))) {
                    return candidate;
                }
            }
            return null;
        });
    }

    private String getListItemPath(Repository repository, BrowseNode browseNode, Asset asset) {
        String listItemPath = asset == null ? String.valueOf(escapeHelper.uri(browseNode.getName())) + "/" : String.valueOf(repository.getUrl()) + "/" + Stream.of(asset.name().split("/")).map(arg_0 -> ((EscapeHelper)escapeHelper).uri(arg_0)).collect(Collectors.joining("/"));
        return listItemPath;
    }
}

