/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.orient;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.browse.internal.orient.OrientBrowseNodeStore;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentStore;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@Singleton
public class OrientBrowseNodeManager
extends ComponentSupport {
    private static final String DEFAULT_PATH_HANDLER = "default";
    private final OrientBrowseNodeStore browseNodeStore;
    private final ComponentStore componentStore;
    private final Map<String, BrowseNodeGenerator> pathGenerators;
    private final BrowseNodeGenerator defaultGenerator;

    @Inject
    public OrientBrowseNodeManager(OrientBrowseNodeStore browseNodeStore, ComponentStore componentStore, Map<String, BrowseNodeGenerator> pathGenerators) {
        this.browseNodeStore = (OrientBrowseNodeStore)((Object)Preconditions.checkNotNull((Object)((Object)browseNodeStore)));
        this.componentStore = (ComponentStore)Preconditions.checkNotNull((Object)componentStore);
        this.pathGenerators = (Map)Preconditions.checkNotNull(pathGenerators);
        this.defaultGenerator = (BrowseNodeGenerator)Preconditions.checkNotNull((Object)pathGenerators.get(DEFAULT_PATH_HANDLER));
    }

    public void createFromAsset(String repositoryName, Asset asset) {
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)asset);
        BrowseNodeGenerator generator = this.pathGenerators.getOrDefault(asset.format(), this.defaultGenerator);
        this.createBrowseNodes(repositoryName, asset.format(), generator, asset);
    }

    public void maybeCreateFromUpdatedAsset(String repositoryName, EntityId assetId, Asset asset) {
        Preconditions.checkNotNull((Object)assetId);
        if (asset.blobRef() == null) {
            this.log.trace("asset {} has no content, not creating browse node", (Object)assetId);
        } else if (this.browseNodeStore.assetNodeExists(asset)) {
            this.log.trace("browse node already exists for {} on update", (Object)assetId);
        } else {
            this.log.trace("adding browse node for {} on update", (Object)assetId);
            this.createFromAsset(repositoryName, asset);
        }
    }

    public void createFromAssets(Repository repository, Iterable<Asset> assets) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(assets);
        String repositoryName = repository.getName();
        BrowseNodeGenerator generator = this.pathGenerators.getOrDefault(repository.getFormat().getValue(), this.defaultGenerator);
        assets.forEach(asset -> this.createBrowseNodes(repositoryName, repository.getFormat().getValue(), generator, (Asset)asset));
    }

    private void createBrowseNodes(String repositoryName, String format, BrowseNodeGenerator generator, Asset asset) {
        try {
            List<BrowsePath> componentPaths;
            Component component = asset.componentId() != null ? this.componentStore.read(asset.componentId()) : null;
            List<BrowsePath> assetPaths = generator.computeAssetPaths(asset, component);
            if (!assetPaths.isEmpty()) {
                this.browseNodeStore.createAssetNode(repositoryName, format, assetPaths, asset);
            }
            if (component != null && !(componentPaths = generator.computeComponentPaths(asset, component)).isEmpty()) {
                this.browseNodeStore.createComponentNode(repositoryName, format, componentPaths, component);
            }
        }
        catch (RuntimeException e) {
            this.log.warn("Problem generating browse nodes for {}", (Object)asset, (Object)e);
        }
    }

    public void deleteAssetNode(Asset asset) {
        this.browseNodeStore.deleteAssetNode(asset);
    }

    public void deleteComponentNode(Component component) {
        this.browseNodeStore.deleteComponentNode(component);
    }

    public void deleteByRepository(String repositoryName) {
        this.browseNodeStore.deleteByRepository(repositoryName);
    }
}

