/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.HasLocality;
import org.sonatype.nexus.orient.ReplicationModeOverrides;
import org.sonatype.nexus.repository.browse.internal.orient.OrientBrowseNodeManager;
import org.sonatype.nexus.repository.browse.node.BrowseNodeEventHandler;
import org.sonatype.nexus.repository.browse.node.BrowseNodeEventHandlerSupport;
import org.sonatype.nexus.repository.config.ConfigurationDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;

@Singleton
@Named
public class OrientBrowseNodeEventHandler
extends BrowseNodeEventHandlerSupport
implements EventAware,
EventAware.Asynchronous,
BrowseNodeEventHandler {
    private final OrientBrowseNodeManager browseNodeManager;

    @Inject
    public OrientBrowseNodeEventHandler(OrientBrowseNodeManager browseNodeManager) {
        this.browseNodeManager = (OrientBrowseNodeManager)((Object)Preconditions.checkNotNull((Object)((Object)browseNodeManager)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent event) {
        this.handle(event, e -> this.browseNodeManager.createFromAsset(e.getRepositoryName(), e.getAsset()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetUpdatedEvent event) {
        this.handle(event, e -> this.browseNodeManager.maybeCreateFromUpdatedAsset(e.getRepositoryName(), e.getAssetId(), e.getAsset()));
    }

    @Subscribe
    public void on(AssetDeletedEvent event) {
        this.handle(event, e -> this.browseNodeManager.deleteAssetNode(e.getAsset()));
    }

    @Subscribe
    public void on(ComponentDeletedEvent event) {
        this.handle(event, e -> this.browseNodeManager.deleteComponentNode(e.getComponent()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ConfigurationDeletedEvent event) {
        this.handle(event, e -> this.browseNodeManager.deleteByRepository(e.getRepositoryName()));
    }

    private <E extends HasLocality> void handle(E event, Consumer<E> consumer) {
        if (this.shouldHandle()) {
            Preconditions.checkNotNull(event);
            if (event.isLocal()) {
                ReplicationModeOverrides.dontWaitForReplicationResults();
                try {
                    consumer.accept(event);
                }
                finally {
                    ReplicationModeOverrides.clearReplicationModeOverrides();
                }
            }
        }
    }
}

