/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.orient;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowsePath;

public class OrientBrowseNode
extends AbstractEntity
implements BrowseNode {
    private String repositoryName;
    private String format;
    private String path;
    private String parentPath;
    private String name;
    private boolean leaf;
    @Nullable
    private String packageUrl;
    @Nullable
    private EntityId componentId;
    @Nullable
    private EntityId assetId;

    public String getRepositoryName() {
        return this.require(this.repositoryName, "repository_name");
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = (String)Preconditions.checkNotNull((Object)repositoryName);
    }

    public String getFormat() {
        return this.require(this.format, "format");
    }

    public void setFormat(String format) {
        this.format = (String)Preconditions.checkNotNull((Object)format);
    }

    public String getPath() {
        return this.require(this.path, "path");
    }

    public void setPath(String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
    }

    public String getParentPath() {
        return this.require(this.parentPath, "parent_path");
    }

    public void setParentPath(String parentPath) {
        this.parentPath = (String)Preconditions.checkNotNull((Object)parentPath);
    }

    public String getName() {
        return this.require(this.name, "name");
    }

    public void setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    @Nullable
    public EntityId getComponentId() {
        return this.componentId;
    }

    public void setComponentId(EntityId componentId) {
        this.componentId = (EntityId)Preconditions.checkNotNull((Object)componentId);
    }

    @Nullable
    public EntityId getAssetId() {
        return this.assetId;
    }

    public void setAssetId(EntityId assetId) {
        this.assetId = (EntityId)Preconditions.checkNotNull((Object)assetId);
    }

    public void setPaths(List<? extends BrowsePath> paths) {
        this.setParentPath(OrientBrowseNode.joinPath(paths.subList(0, paths.size() - 1).stream().map(BrowsePath::getDisplayName).collect(Collectors.toList())));
        this.setName(paths.get(paths.size() - 1).getDisplayName());
        this.setPath(paths.get(paths.size() - 1).getRequestPath());
    }

    private static String joinPath(List<String> path) {
        StringBuilder buf = new StringBuilder("/");
        path.forEach(s -> {
            StringBuilder stringBuilder2 = buf.append((String)s).append("/");
        });
        return buf.toString();
    }

    private <V> V require(V value, String name) {
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"Missing property: %s", (Object)name);
        return value;
    }

    public String toString() {
        return "BrowseNode{repositoryName=" + this.repositoryName + ", format=" + this.format + ", parentPath=" + this.parentPath + ", name=" + this.name + ", path=" + this.path + ", leaf=" + this.leaf + ", componentId='" + this.componentId + '\'' + ", assetId='" + this.assetId + '\'' + '}';
    }

    @Nullable
    public String getPackageUrl() {
        return this.packageUrl;
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }
}

