/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.browse.node.BrowseNodeConfiguration;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class RebuildBrowseNodesManager
extends StateGuardLifecycleSupport {
    @VisibleForTesting
    static final String SELECT_ANY_ASSET_BY_BUCKET = "select @rid from asset where bucket = :bucket limit 1";
    @VisibleForTesting
    static final String SELECT_ANY_BROWSE_NODE_BY_BUCKET = "select @rid from browse_node where repository_name = :repositoryName limit 1";
    private final Provider<DatabaseInstance> componentDatabaseInstanceProvider;
    private final TaskScheduler taskScheduler;
    private final boolean automaticRebuildEnabled;
    private final BucketEntityAdapter bucketEntityAdapter;

    @Inject
    public RebuildBrowseNodesManager(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstanceProvider, TaskScheduler taskScheduler, BrowseNodeConfiguration configuration, BucketEntityAdapter bucketEntityAdapter) {
        this.componentDatabaseInstanceProvider = (Provider)Preconditions.checkNotNull(componentDatabaseInstanceProvider);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.automaticRebuildEnabled = ((BrowseNodeConfiguration)Preconditions.checkNotNull((Object)configuration)).isAutomaticRebuildEnabled();
        this.bucketEntityAdapter = bucketEntityAdapter;
    }

    protected void doStart() {
        if (!this.automaticRebuildEnabled) {
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        try {
            boolean existingTask;
            Collection buckets = (Collection)OrientTransactional.inTx(this.componentDatabaseInstanceProvider).call(db -> Streams.stream((Iterable)this.bucketEntityAdapter.browse(db)).filter(bucket -> {
                boolean hasBrowseNodes;
                if (bucket.attributes().contains("pendingDeletion")) {
                    this.log.debug("browse_node table won't be rebuilt for bucket={} as it is marked for deletion", (Object)AttachedEntityHelper.id((Entity)bucket));
                    return false;
                }
                boolean hasAssets = !this.execute(db, SELECT_ANY_ASSET_BY_BUCKET, Collections.singletonMap("bucket", AttachedEntityHelper.id((Entity)bucket))).isEmpty();
                boolean bl = hasBrowseNodes = !this.execute(db, SELECT_ANY_BROWSE_NODE_BY_BUCKET, Collections.singletonMap("repositoryName", bucket.getRepositoryName())).isEmpty();
                if (hasAssets ^ hasBrowseNodes) {
                    this.log.debug("browse_node table will be rebuilt for bucket={}", (Object)AttachedEntityHelper.id((Entity)bucket));
                    return true;
                }
                if (!hasAssets) {
                    this.log.debug("browse_node table won't be populated as there are no assets for bucketId={}", (Object)AttachedEntityHelper.id((Entity)bucket));
                } else {
                    this.log.debug("browse_node table already populated for bucketId={}", (Object)AttachedEntityHelper.id((Entity)bucket));
                }
                return false;
            }).collect(Collectors.toList()));
            String repositoryNames = buckets.stream().map(Bucket::getRepositoryName).collect(Collectors.joining(","));
            if (!Strings2.isEmpty((String)repositoryNames) && !(existingTask = this.taskScheduler.findAndSubmit("create.browse.nodes", (Map)ImmutableMap.of((Object)"repositoryName", (Object)repositoryNames)))) {
                this.launchNewTask(repositoryNames);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to determine if the browse nodes need to be rebuilt for any repositories", (Throwable)e);
        }
        this.log.debug("scheduling rebuild browse nodes tasks took {} ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
    }

    private void launchNewTask(String repositoryNames) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("create.browse.nodes");
        configuration.setString("repositoryName", repositoryNames);
        configuration.setName("Rebuild repository browse tree - (" + repositoryNames + ")");
        this.taskScheduler.submit(configuration);
    }

    private List<ODocument> execute(ODatabaseDocumentTx db, String query, Map<String, Object> parameters) {
        return (List)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
    }
}

