/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named
public class DefaultBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    @Override
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<BrowsePaths> paths = this.computeComponentPaths(asset, component);
            String lastSegment = this.lastSegment(asset.name());
            BrowsePaths.appendPath(paths, lastSegment);
            return paths;
        }
        return super.computeAssetPaths(asset, component);
    }

    @Override
    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!Strings2.isBlank((String)component.group())) {
            paths.add(component.group());
        }
        paths.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            paths.add(component.version());
        }
        return BrowsePaths.fromPaths(paths, true);
    }
}

