/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.internal.BrowseMetadataNodeSqlBuilderSupport;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.MetadataNodeEntityAdapter;

@Named
@Singleton
public class BrowseComponentsSqlBuilder
extends BrowseMetadataNodeSqlBuilderSupport {
    private final MetadataNodeEntityAdapter<Component> componentEntityAdapter;

    @Inject
    BrowseComponentsSqlBuilder(ComponentEntityAdapter componentEntityAdapter) {
        this.componentEntityAdapter = (MetadataNodeEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
    }

    protected MetadataNodeEntityAdapter<?> getEntityAdapter() {
        return this.componentEntityAdapter;
    }

    @Override
    protected String getBrowseIndex() {
        return ComponentEntityAdapter.I_GROUP_NAME_VERSION_INSENSITIVE;
    }

    @Override
    Map<String, Object> buildSqlParams(String repositoryName, QueryOptions queryOptions) {
        String lastId;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("browsedRepository", repositoryName);
        String filter = queryOptions.getFilter();
        if (filter != null) {
            String filterValue = "%" + filter + "%";
            params.put("nameFilter", filterValue);
            params.put("groupFilter", filterValue);
            params.put("versionFilter", filterValue);
        }
        if ((lastId = queryOptions.getLastId()) != null) {
            params.put("rid", lastId);
        }
        return params;
    }

    @Override
    protected String buildWhereClause(List<String> bucketIds, QueryOptions queryOptions) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        whereClauses.add(bucketIds.stream().map(bucket -> "bucket = " + bucket).collect(Collectors.joining(" OR ")));
        if (queryOptions.getContentAuth()) {
            whereClauses.add("contentAuth(@this.name, @this.format, :browsedRepository) == true");
        }
        if (queryOptions.getFilter() != null) {
            whereClauses.add("name LIKE :nameFilter OR group LIKE :groupFilter OR version LIKE :versionFilter");
        }
        if (queryOptions.getLastId() != null) {
            whereClauses.add("@rid > :rid");
        }
        return whereClauses.stream().map(clause -> "(" + clause + ")").collect(Collectors.joining(" AND "));
    }
}

