/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.selector.internal.OrientContentAuthHelper;

public class BrowseAssetIterator
extends ComponentSupport
implements Iterator<ODocument> {
    private static final String ASSET = "asset";
    private static final String BUCKET = "bucket";
    static final String QUERY_TEMPLATE = "select from asset where @rid > %s";
    private int count = 0;
    private String startRid;
    private final Queue<ODocument> queue;
    private final OrientContentAuthHelper contentAuthHelper;
    private final ODatabaseDocumentTx db;
    private final String rid;
    private final String repositoryName;
    private final List<String> bucketIds;
    private final int limit;
    private final int pageSize;
    private boolean hasBrowsedClass = false;

    BrowseAssetIterator(OrientContentAuthHelper contentAuthHelper, ODatabaseDocumentTx db, @Nullable String rid, String repositoryName, List<String> bucketIds, int limit, int pageSize) {
        this.contentAuthHelper = (OrientContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
        this.db = (ODatabaseDocumentTx)Preconditions.checkNotNull((Object)db);
        this.rid = rid;
        this.repositoryName = (String)Preconditions.checkNotNull((Object)repositoryName);
        this.bucketIds = (List)Preconditions.checkNotNull(bucketIds);
        this.limit = limit;
        this.pageSize = pageSize;
        this.queue = new ArrayDeque<ODocument>(pageSize);
        this.startRid = rid;
    }

    @Override
    public boolean hasNext() {
        this.fillQueueIfEmpty();
        return this.count < this.limit && !this.queue.isEmpty();
    }

    @Override
    public ODocument next() {
        this.fillQueueIfEmpty();
        ODocument doc = this.queue.poll();
        if (doc != null) {
            ++this.count;
            return doc;
        }
        throw new NoSuchElementException();
    }

    String getRid() {
        return this.rid;
    }

    String getStartRid() {
        return this.startRid;
    }

    List<String> getBucketIds() {
        return this.bucketIds;
    }

    int getLimit() {
        return this.limit;
    }

    String getQuery() {
        if (this.getRid() == null) {
            return "<<browse class asset>>";
        }
        return String.format(QUERY_TEMPLATE, this.getStartRid());
    }

    int getCount() {
        return this.count;
    }

    int getPageSize() {
        return this.pageSize;
    }

    boolean isHasBrowsedClass() {
        return this.hasBrowsedClass;
    }

    private List<ODocument> getPage() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.toString());
        }
        if (this.rid == null) {
            return this.browseClass();
        }
        return this.db.query((OQuery)new OSQLSynchQuery(this.getQuery(), this.pageSize), new Object[0]);
    }

    private List<ODocument> browseClass() {
        if (this.hasBrowsedClass) {
            return Collections.emptyList();
        }
        this.hasBrowsedClass = true;
        return StreamSupport.stream(this.db.browseClass(ASSET).spliterator(), false).filter(this.bucketFilter()).filter(this.contentAuthFilter()).limit(this.limit).collect(Collectors.toList());
    }

    private void fillQueueIfEmpty() {
        while (this.queue.isEmpty()) {
            List<ODocument> docs = this.getPage();
            if (docs.isEmpty()) break;
            Stream<Object> docStream = docs.stream();
            if (!this.hasBrowsedClass) {
                docStream = docStream.filter(this.bucketFilter()).filter(this.contentAuthFilter());
            }
            docStream.forEach(this.queue::add);
            this.startRid = docs.get(docs.size() - 1).getIdentity().toString();
        }
    }

    private Predicate<ODocument> bucketFilter() {
        if (this.bucketIds.isEmpty()) {
            return doc -> true;
        }
        return doc -> this.bucketIds.contains(BrowseAssetIterator.toBucketId(doc.field(BUCKET)));
    }

    private Predicate<ODocument> contentAuthFilter() {
        return doc -> this.contentAuthHelper.checkPathPermissions((String)doc.field("name"), (String)doc.field("format"), this.repositoryName);
    }

    private static String toBucketId(Object obj) {
        if (obj instanceof ODocument) {
            return ((ODocument)obj).getIdentity().toString();
        }
        return obj.toString();
    }

    public String toString() {
        return "BrowseAssetIterator{query=" + this.getQuery() + ", rid=" + this.rid + ", startRid=" + this.startRid + ", bucketIds=[" + String.join((CharSequence)", ", this.bucketIds) + "]" + ", limit=" + this.limit + ", count=" + this.count + ", pageSize= " + this.pageSize + ", hasBrowsedClass= " + this.hasBrowsedClass + '}';
    }
}

