/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.text.Strings2;

public class AssetWhereClauseBuilder {
    private AssetWhereClauseBuilder() {
    }

    @Nullable
    public static String whereClause(@Nullable String content, boolean includeFilter, boolean includeLastId) {
        ArrayList clauses = Lists.newArrayList();
        if (!Strings2.isBlank((String)content)) {
            clauses.add(content);
        }
        if (includeFilter) {
            clauses.add("name LIKE :nameFilter");
        }
        if (includeLastId) {
            clauses.add("@rid > :rid");
        }
        if (!clauses.isEmpty()) {
            return Joiner.on((String)" AND ").join((Iterable)clauses);
        }
        return null;
    }

    @Nullable
    public static String whereClause(String content, boolean includeFilter) {
        return AssetWhereClauseBuilder.whereClause(content, includeFilter, false);
    }
}

