/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.coreui.AssetXO;
import org.sonatype.nexus.coreui.ComponentHelper;
import org.sonatype.nexus.coreui.ComponentXO;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetVariableResolver;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentFinder;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.selector.VariableSource;

@Priority(value=0x7FFFFFFF)
@Named
@Singleton
public class OrientComponentHelper
extends ComponentSupport
implements ComponentHelper {
    private final RepositoryManager repositoryManager;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final BrowseService browseService;
    private final MaintenanceService maintenanceService;
    private final Map<String, ComponentFinder> componentFinders;
    private final BucketStore bucketStore;

    @VisibleForTesting
    static ComponentXO COMPONENT_CONVERTER(Component component, String repositoryName) {
        ComponentXO componentXO = new ComponentXO();
        componentXO.setId(EntityHelper.id((Entity)component).getValue());
        componentXO.setRepositoryName(repositoryName);
        componentXO.setGroup(component.group());
        componentXO.setName(component.name());
        componentXO.setVersion(component.version());
        componentXO.setFormat(component.format());
        return componentXO;
    }

    private static AssetXO ASSET_CONVERTER(Asset asset, String repositoryName, String privilegedRepositoryName) {
        AssetXO assetXO = new AssetXO();
        assetXO.setId(EntityHelper.id((Entity)asset).getValue());
        assetXO.setName(asset.name());
        assetXO.setFormat(asset.format());
        assetXO.setContentType(asset.contentType() != null ? asset.contentType() : "unknown");
        assetXO.setSize(asset.size() != null ? asset.size() : 0L);
        assetXO.setRepositoryName(repositoryName);
        assetXO.setContainingRepositoryName(privilegedRepositoryName);
        assetXO.setBlobCreated(asset.blobCreated() != null ? asset.blobCreated().toDate() : null);
        assetXO.setBlobUpdated(asset.blobUpdated() != null ? asset.blobUpdated().toDate() : null);
        assetXO.setLastDownloaded(asset.lastDownloaded() != null ? asset.lastDownloaded().toDate() : null);
        assetXO.setBlobRef(asset.blobRef() != null ? asset.blobRef().toString() : "");
        assetXO.setComponentId(asset.componentId() != null ? asset.componentId().getValue() : "");
        assetXO.setAttributes(asset.attributes().backing());
        assetXO.setCreatedBy(asset.createdBy());
        assetXO.setCreatedByIp(asset.createdByIp());
        return assetXO;
    }

    @Inject
    public OrientComponentHelper(RepositoryManager repositoryManager, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager, BrowseService browseService, MaintenanceService maintenanceService, Map<String, ComponentFinder> componentFinders, BucketStore bucketStore) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.browseService = (BrowseService)Preconditions.checkNotNull((Object)browseService);
        this.maintenanceService = (MaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
        this.componentFinders = (Map)Preconditions.checkNotNull(componentFinders);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
    }

    @Override
    public List<AssetXO> readComponentAssets(Repository repository, ComponentXO componentXO) {
        ComponentFinder componentFinder = this.componentFinders.get(componentXO.getFormat());
        if (componentFinder == null) {
            componentFinder = this.componentFinders.get("default");
        }
        List components = componentFinder.findMatchingComponents(repository, componentXO.getId(), componentXO.getGroup(), componentXO.getName(), componentXO.getVersion());
        PageResult browseResult = this.browseService.browseComponentAssets(repository, (Component)components.get(0));
        return this.createAssetXOs(browseResult.getResults(), repository);
    }

    @Override
    public PageResult<AssetXO> previewAssets(RepositorySelector repositorySelector, List<Repository> selectedRepositories, String jexlExpression, QueryOptions queryOptions) {
        PageResult page = this.browseService.previewAssets(repositorySelector, selectedRepositories, jexlExpression, queryOptions);
        return new PageResult(page.getTotal(), page.getResults().stream().map(asset -> OrientComponentHelper.ASSET_CONVERTER(asset, null, null)).collect(Collectors.toList()));
    }

    @Override
    public ComponentXO readComponent(Repository repository, EntityId componentId) {
        ArrayList assets;
        Component component;
        Throwable throwable = null;
        Object var6_5 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            component = storageTx.findComponent(componentId);
            if (component == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Iterable browsedAssets = storageTx.browseAssets(component);
            if (browsedAssets == null || Iterables.isEmpty((Iterable)browsedAssets)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            assets = Lists.newArrayList((Iterable)browsedAssets);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.ensurePermissions(repository, assets, "browse");
        return OrientComponentHelper.COMPONENT_CONVERTER(component, repository.getName());
    }

    @Override
    public boolean canDeleteComponent(Repository repository, ComponentXO componentXO) {
        List<Component> components = this.getComponents(repository, componentXO);
        for (Component component : components) {
            if (this.maintenanceService.canDeleteComponent(repository, component)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> deleteComponent(Repository repository, ComponentXO componentXO) {
        List<Component> components = this.getComponents(repository, componentXO);
        HashSet<String> deletedAssets = new HashSet<String>();
        for (Component component : components) {
            deletedAssets.addAll(this.maintenanceService.deleteComponent(repository, component));
        }
        return deletedAssets;
    }

    private List<Component> getComponents(Repository repository, ComponentXO componentXO) {
        ComponentFinder componentFinder = this.componentFinders.get(componentXO.getFormat());
        if (componentFinder == null) {
            componentFinder = this.componentFinders.get("default");
        }
        return componentFinder.findMatchingComponents(repository, componentXO.getId(), componentXO.getGroup(), componentXO.getName(), componentXO.getVersion());
    }

    @Override
    public AssetXO readAsset(Repository repository, EntityId assetId) {
        Asset asset = this.browseService.getAssetById(assetId, repository);
        if (asset == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Bucket bucket = this.bucketStore.getById(asset.bucketId());
        if (bucket == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String permittedRepositoryName = this.ensurePermissions(this.repositoryManager.get(bucket.getRepositoryName()), Collections.singletonList(asset), "browse");
        return OrientComponentHelper.ASSET_CONVERTER(asset, repository.getName(), permittedRepositoryName);
    }

    @Override
    public boolean canDeleteAsset(Repository repository, EntityId assetId) {
        Asset asset = this.getAsset(repository, assetId);
        if (asset != null) {
            return this.maintenanceService.canDeleteAsset(repository, asset);
        }
        return false;
    }

    @Override
    public Set<String> deleteAsset(Repository repository, EntityId assetId) {
        Asset asset = this.getAsset(repository, assetId);
        if (asset != null) {
            return this.maintenanceService.deleteAsset(repository, asset);
        }
        return Collections.emptySet();
    }

    private Asset getAsset(Repository repository, EntityId assetId) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx storageTx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            return storageTx.findAsset(assetId, storageTx.findBucket(repository));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean canDeleteFolder(Repository repository, String path) {
        return this.maintenanceService.canDeleteFolder(repository, path);
    }

    @Override
    public void deleteFolder(Repository repository, String path) {
        this.maintenanceService.deleteFolder(repository, path);
    }

    private String ensurePermissions(Repository repository, Iterable<Asset> assets, String action) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(assets);
        Preconditions.checkNotNull((Object)action);
        AssetVariableResolver assetVariableResolver = (AssetVariableResolver)this.variableResolverAdapterManager.get(repository.getFormat().getValue());
        List repositoryNames = this.repositoryManager.findContainingGroups(repository.getName());
        repositoryNames.add(0, repository.getName());
        for (Asset asset : assets) {
            VariableSource variableSource = assetVariableResolver.fromAsset(asset);
            String repositoryName = this.getPrivilegedRepositoryName(repositoryNames, repository.getFormat().getValue(), action, variableSource);
            if (repositoryName == null) continue;
            return repositoryName;
        }
        throw new AuthorizationException();
    }

    private List<AssetXO> createAssetXOs(List<Asset> assets, Repository repository) {
        ArrayList<AssetXO> assetXOs = new ArrayList<AssetXO>();
        for (Asset asset : assets) {
            String privilegedRepositoryName = this.getPrivilegedRepositoryName(repository, asset);
            assetXOs.add(OrientComponentHelper.ASSET_CONVERTER(asset, repository.getName(), privilegedRepositoryName));
        }
        return assetXOs;
    }

    private String getPrivilegedRepositoryName(Repository repository, Asset asset) {
        AssetVariableResolver assetVariableResolver = (AssetVariableResolver)this.variableResolverAdapterManager.get(repository.getFormat().getValue());
        VariableSource variableSource = assetVariableResolver.fromAsset(asset);
        Bucket bucket = this.bucketStore.getById(asset.bucketId());
        if (bucket != null) {
            String assetRepositoryName = bucket.getRepositoryName();
            List repositoryNames = this.repositoryManager.findContainingGroups(assetRepositoryName);
            repositoryNames.add(0, assetRepositoryName);
            return this.getPrivilegedRepositoryName(repositoryNames, repository.getFormat().getValue(), "browse", variableSource);
        }
        return null;
    }

    private String getPrivilegedRepositoryName(List<String> repositoryNames, String format, String action, VariableSource variableSource) {
        for (String repositoryName : repositoryNames) {
            if (!this.contentPermissionChecker.isPermitted(repositoryName, format, action, variableSource)) continue;
            return repositoryName;
        }
        return null;
    }
}

