/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui.internal.blobstore;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobStoreDescriptor;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorProvider;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuota;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreQuotaTypesUIResponse;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreTypesUIResponse;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreUIResponse;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreUsageUIResponse;
import org.sonatype.nexus.repository.blobstore.BlobStoreConfigurationStore;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/ui/blobstores")
public class BlobStoreUIResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_PATH = "/internal/ui/blobstores";
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreConfigurationStore store;
    private final BlobStoreDescriptorProvider blobStoreDescriptorProvider;
    private final List<BlobStoreQuotaTypesUIResponse> blobStoreQuotaTypes;
    private final RepositoryManager repositoryManager;

    @Inject
    public BlobStoreUIResource(BlobStoreManager blobStoreManager, BlobStoreConfigurationStore store, BlobStoreDescriptorProvider blobStoreDescriptorProvider, Map<String, BlobStoreQuota> quotaFactories, RepositoryManager repositoryManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.store = (BlobStoreConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.blobStoreDescriptorProvider = (BlobStoreDescriptorProvider)Preconditions.checkNotNull((Object)blobStoreDescriptorProvider);
        this.blobStoreQuotaTypes = quotaFactories.entrySet().stream().map(BlobStoreQuotaTypesUIResponse::new).collect(Collectors.toList());
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    public List<BlobStoreUIResponse> listBlobStores() {
        return this.store.list().stream().map(configuration -> {
            String typeId = ((BlobStoreDescriptor)this.blobStoreDescriptorProvider.get().get(configuration.getType())).getId();
            BlobStoreMetrics metrics = Optional.ofNullable(this.blobStoreManager.get(configuration.getName())).map(BlobStoreUIResource::getBlobStoreMetrics).orElse(null);
            return new BlobStoreUIResponse(typeId, (BlobStoreConfiguration)configuration, metrics);
        }).collect(Collectors.toList());
    }

    private static BlobStoreMetrics getBlobStoreMetrics(BlobStore bs) {
        if (bs.isGroupable()) {
            return bs.isStarted() ? bs.getMetrics() : null;
        }
        return ((BlobStoreGroup)bs).getMembers().stream().map(BlobStore::isStarted).reduce(Boolean::logicalAnd).orElse(false) != false ? bs.getMetrics() : null;
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/types")
    public List<BlobStoreTypesUIResponse> listBlobStoreTypes() {
        return this.blobStoreDescriptorProvider.get().entrySet().stream().filter(entry -> ((BlobStoreDescriptor)entry.getValue()).isEnabled()).map(BlobStoreTypesUIResponse::new).collect(Collectors.toList());
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/usage/{name}")
    public BlobStoreUsageUIResponse getBlobStoreUsage(@PathParam(value="name") String name) {
        long repositoryUsage = this.repositoryManager.blobstoreUsageCount(name);
        long blobStoreUsage = this.blobStoreManager.blobStoreUsageCount(name);
        return new BlobStoreUsageUIResponse(repositoryUsage, blobStoreUsage);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/quotaTypes")
    public List<BlobStoreQuotaTypesUIResponse> listQuotaTypes() {
        return this.blobStoreQuotaTypes;
    }
}

