/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotEmpty;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.coreui.AssetXO;
import org.sonatype.nexus.coreui.ComponentHelper;
import org.sonatype.nexus.coreui.ComponentXO;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.extdirect.model.StoreLoadParameters;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorFactory;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"coreui_Component"})
public class ComponentComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private SecurityHelper securityHelper;
    @Inject
    private RepositoryManager repositoryManager;
    @Inject
    private ContentPermissionChecker contentPermissionChecker;
    @Inject
    private VariableResolverAdapterManager variableResolverAdapterManager;
    @Inject
    private SelectorFactory selectorFactory;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private ComponentHelper componentHelper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ComponentComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    public List<AssetXO> readComponentAssets(StoreLoadParameters parameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        String repositoryName = ShortTypeHandling.castToString((Object)callSiteArray[0].call((Object)parameters, (Object)"repositoryName"));
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty((Object)repository)))) {
            return (List)ScriptBytecodeAdapter.castToType(null, List.class);
        }
        ComponentXO componentXO = (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call((Object)this.objectMapper, callSiteArray[5].call((Object)parameters, (Object)"componentModel"), ComponentXO.class), ComponentXO.class);
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call((Object)this.componentHelper, (Object)repository, (Object)componentXO), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:selectors:*"})
    public PagedResponse<AssetXO> previewAssets(StoreLoadParameters parameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        String repositoryName = ShortTypeHandling.castToString((Object)callSiteArray[7].call((Object)parameters, (Object)"repositoryName"));
        String expression = ShortTypeHandling.castToString((Object)callSiteArray[8].call((Object)parameters, (Object)"expression"));
        String type = ShortTypeHandling.castToString((Object)callSiteArray[9].call((Object)parameters, (Object)"type"));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)expression) || !DefaultTypeTransformation.booleanUnbox((Object)type) || !DefaultTypeTransformation.booleanUnbox((Object)repositoryName) : !DefaultTypeTransformation.booleanUnbox((Object)expression) || !DefaultTypeTransformation.booleanUnbox((Object)type) || !DefaultTypeTransformation.booleanUnbox((Object)repositoryName)) {
            return (PagedResponse)ScriptBytecodeAdapter.castToType(null, PagedResponse.class);
        }
        callSiteArray[10].call((Object)this.selectorFactory, (Object)type, (Object)expression);
        RepositorySelector repositorySelector = (RepositorySelector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(RepositorySelector.class, (Object)repositoryName), RepositorySelector.class);
        List selectedRepositories = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)repositorySelector), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)selectedRepositories))) {
            return (PagedResponse)ScriptBytecodeAdapter.castToType(null, PagedResponse.class);
        }
        PageResult result = (PageResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call((Object)this.componentHelper, (Object)repositorySelector, (Object)selectedRepositories, (Object)expression, callSiteArray[15].callCurrent((GroovyObject)this, (Object)parameters)), PageResult.class);
        return (PagedResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(PagedResponse.class, callSiteArray[17].callGetProperty((Object)result), callSiteArray[18].callGetProperty((Object)result)), PagedResponse.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public boolean canDeleteComponent(@NotEmpty String componentModelString) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        ComponentXO componentXO = (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call((Object)this.objectMapper, (Object)componentModelString, ComponentXO.class), ComponentXO.class);
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)this.repositoryManager, callSiteArray[21].callGroovyObjectGetProperty((Object)componentXO)), Repository.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)this.componentHelper, (Object)repository, (Object)componentXO));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public Set<String> deleteComponent(@NotEmpty String componentModelString) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        ComponentXO componentXO = (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call((Object)this.objectMapper, (Object)componentModelString, ComponentXO.class), ComponentXO.class);
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call((Object)this.repositoryManager, callSiteArray[25].callGroovyObjectGetProperty((Object)componentXO)), Repository.class);
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call((Object)this.componentHelper, (Object)repository, (Object)componentXO), Set.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public boolean canDeleteAsset(@NotEmpty String assetId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)this.componentHelper, (Object)repository, callSiteArray[29].callConstructor(DetachedEntityId.class, (Object)assetId)));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public Set<String> deleteAsset(@NotEmpty String assetId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(HashSet.class, callSiteArray[32].call((Object)this.componentHelper, (Object)repository, callSiteArray[33].callConstructor(DetachedEntityId.class, (Object)assetId))), Set.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @Nullable
    public ComponentXO readComponent(@NotEmpty String componentId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        return (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call((Object)this.componentHelper, (Object)repository, callSiteArray[36].callConstructor(DetachedEntityId.class, (Object)componentId)), ComponentXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @Nullable
    public AssetXO readAsset(@NotEmpty String assetId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        return (AssetXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call((Object)this.componentHelper, (Object)repository, callSiteArray[39].callConstructor(DetachedEntityId.class, (Object)assetId)), AssetXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public boolean canDeleteFolder(@NotEmpty String path, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call((Object)this.componentHelper, (Object)repository, (Object)path));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public void deleteFolder(@NotEmpty String path, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        callSiteArray[43].call((Object)this.componentHelper, (Object)repository, (Object)path);
    }

    private QueryOptions toQueryOptions(StoreLoadParameters storeLoadParameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Object sort = callSiteArray[44].callSafe(callSiteArray[45].callGetProperty((Object)storeLoadParameters), (Object)0);
        return (QueryOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callConstructor(QueryOptions.class, ArrayUtil.createArray((Object)callSiteArray[47].call((Object)storeLoadParameters, (Object)"filter"), (Object)callSiteArray[48].callGetPropertySafe(sort), (Object)callSiteArray[49].callGetPropertySafe(sort), (Object)callSiteArray[50].callGetProperty((Object)storeLoadParameters), (Object)callSiteArray[51].callGetProperty((Object)storeLoadParameters))), QueryOptions.class);
    }

    private List<Repository> getPreviewRepositories(RepositorySelector repositorySelector) {
        Reference repositorySelector2 = new Reference((Object)repositorySelector);
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].callGetProperty((Object)((RepositorySelector)repositorySelector2.get())))) {
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call(ImmutableList.class, callSiteArray[54].call((Object)this.repositoryManager, callSiteArray[55].callGetProperty((Object)((RepositorySelector)repositorySelector2.get())))), List.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGetProperty((Object)((RepositorySelector)repositorySelector2.get())))) {
            public final class _getPreviewRepositories_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference repositorySelector;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getPreviewRepositories_closure1(Object _outerInstance, Object _thisObject, Reference repositorySelector) {
                    Reference reference;
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.repositorySelector = reference = repositorySelector;
                }

                public Object doCall(Repository repository) {
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)repository)), (Object)callSiteArray[2].callGetProperty(this.repositorySelector.get())) ? repository : null;
                }

                @Generated
                public Object call(Repository repository) {
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)repository);
                }

                @Generated
                public RepositorySelector getRepositorySelector() {
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    return (RepositorySelector)ScriptBytecodeAdapter.castToType((Object)this.repositorySelector.get(), RepositorySelector.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getPreviewRepositories_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "value";
                    stringArray[1] = "format";
                    stringArray[2] = "format";
                    stringArray[3] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _getPreviewRepositories_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getPreviewRepositories_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getPreviewRepositories_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call(callSiteArray[58].call((Object)this.repositoryManager), (Object)new _getPreviewRepositories_closure1((Object)this, (Object)this, repositorySelector2)), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call(callSiteArray[60].call((Object)this.repositoryManager)), List.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ComponentComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    @Generated
    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    @Generated
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @Generated
    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    @Generated
    public ContentPermissionChecker getContentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    @Generated
    public void setContentPermissionChecker(ContentPermissionChecker contentPermissionChecker) {
        this.contentPermissionChecker = contentPermissionChecker;
    }

    @Generated
    public VariableResolverAdapterManager getVariableResolverAdapterManager() {
        return this.variableResolverAdapterManager;
    }

    @Generated
    public void setVariableResolverAdapterManager(VariableResolverAdapterManager variableResolverAdapterManager) {
        this.variableResolverAdapterManager = variableResolverAdapterManager;
    }

    @Generated
    public SelectorFactory getSelectorFactory() {
        return this.selectorFactory;
    }

    @Generated
    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public ComponentHelper getComponentHelper() {
        return this.componentHelper;
    }

    @Generated
    public void setComponentHelper(ComponentHelper componentHelper) {
        this.componentHelper = componentHelper;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getFilter";
        stringArray[1] = "get";
        stringArray[2] = "online";
        stringArray[3] = "configuration";
        stringArray[4] = "readValue";
        stringArray[5] = "getFilter";
        stringArray[6] = "readComponentAssets";
        stringArray[7] = "getFilter";
        stringArray[8] = "getFilter";
        stringArray[9] = "getFilter";
        stringArray[10] = "validateSelector";
        stringArray[11] = "fromSelector";
        stringArray[12] = "getPreviewRepositories";
        stringArray[13] = "size";
        stringArray[14] = "previewAssets";
        stringArray[15] = "toQueryOptions";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "total";
        stringArray[18] = "results";
        stringArray[19] = "readValue";
        stringArray[20] = "get";
        stringArray[21] = "repositoryName";
        stringArray[22] = "canDeleteComponent";
        stringArray[23] = "readValue";
        stringArray[24] = "get";
        stringArray[25] = "repositoryName";
        stringArray[26] = "deleteComponent";
        stringArray[27] = "get";
        stringArray[28] = "canDeleteAsset";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "get";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "deleteAsset";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "get";
        stringArray[35] = "readComponent";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "get";
        stringArray[38] = "readAsset";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "get";
        stringArray[41] = "canDeleteFolder";
        stringArray[42] = "get";
        stringArray[43] = "deleteFolder";
        stringArray[44] = "get";
        stringArray[45] = "sort";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "getFilter";
        stringArray[48] = "property";
        stringArray[49] = "direction";
        stringArray[50] = "start";
        stringArray[51] = "limit";
        stringArray[52] = "allRepositories";
        stringArray[53] = "of";
        stringArray[54] = "get";
        stringArray[55] = "name";
        stringArray[56] = "allFormats";
        stringArray[57] = "findResults";
        stringArray[58] = "browse";
        stringArray[59] = "collect";
        stringArray[60] = "browse";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[61];
        ComponentComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ComponentComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ComponentComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

