/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.aggregation;

import com.google.api.core.InternalApi;
import com.google.cloud.datastore.aggregation.Aggregation;
import com.google.cloud.datastore.aggregation.AggregationBuilder;
import com.google.common.base.Preconditions;
import com.google.datastore.v1.AggregationQuery;
import com.google.datastore.v1.PropertyReference;
import java.util.Objects;

public class AvgAggregation
extends Aggregation {
    private final String propertyReference;

    public AvgAggregation(String alias, String propertyReference) {
        super(alias);
        Preconditions.checkArgument((propertyReference != null ? 1 : 0) != 0, (Object)"Property reference can't be null");
        this.propertyReference = propertyReference;
    }

    @Override
    @InternalApi
    public AggregationQuery.Aggregation toPb() {
        PropertyReference reference = PropertyReference.newBuilder().setName(this.propertyReference).build();
        AggregationQuery.Aggregation.Avg avg = AggregationQuery.Aggregation.Avg.newBuilder().setProperty(reference).build();
        return this.aggregationBuilder().setAvg(avg).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvgAggregation that = (AvgAggregation)o;
        return Objects.equals(this.propertyReference, that.propertyReference) && Objects.equals(this.getAlias(), that.getAlias());
    }

    public int hashCode() {
        return Objects.hash(this.getAlias(), this.propertyReference);
    }

    public static class Builder
    implements AggregationBuilder<AvgAggregation> {
        private String alias;
        private String propertyReference;

        public Builder propertyReference(String propertyReference) {
            this.propertyReference = propertyReference;
            return this;
        }

        public Builder as(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public AvgAggregation build() {
            return new AvgAggregation(this.alias, this.propertyReference);
        }
    }
}

