/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.proui.internal.tag.datastore;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.proui.internal.tag.TagListComponent;
import com.sonatype.nexus.proui.internal.tag.TagSummaryXO;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import com.sonatype.nexus.tags.service.TagService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.extdirect.model.StoreLoadParameters;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"proui_TagList"})
public class TagListComponentImpl
extends TagListComponent {
    private final int tagLimit;
    private final ComponentTagStoreManager componentTagStoreManager;
    private final TagStore tagStore;

    @Inject
    public TagListComponentImpl(RepositoryManager repositoryManager, TagService tagService, ComponentTagStoreManager componentTagStoreManager, TagStore tagStore, @Named(value="${nexus.tags.componentListTagLimit:-1000}") @Named(value="${nexus.tags.componentListTagLimit:-1000}") int tagLimit) {
        super(repositoryManager, tagService);
        this.componentTagStoreManager = componentTagStoreManager;
        this.tagStore = tagStore;
        this.tagLimit = tagLimit;
    }

    @Override
    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @Nullable
    @RequiresPermissions(value={"nexus:tags:read"})
    public List<TagSummaryXO> readTagListDetails(StoreLoadParameters parameters) {
        String componentId = parameters.getFilter("componentId");
        String repoName = parameters.getFilter("repositoryName");
        if (StringUtils.isEmpty((String)repoName)) {
            return null;
        }
        Repository repository = this.repositoryManager.get(repoName);
        FluentComponent fluentComponent = (FluentComponent)((ContentFacet)repository.facet(ContentFacet.class)).components().find((EntityId)new DetachedEntityId(componentId)).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
        List<Tag> tags = this.getTags(repository, (Component)fluentComponent);
        return tags.stream().map(this::convert).collect(Collectors.toList());
    }

    protected List<Tag> getTags(Repository repository, Component component) {
        Continuation componentTags = this.componentTagStoreManager.getStoreForRepository(repository).browseComponentTags(component, this.tagLimit, null);
        return this.tagStore.getByIds(componentTags.stream().map(ComponentTag::getTagId).collect(Collectors.toSet()));
    }
}

