/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class S3BlobStoreApiBucket {
    @Valid
    @NotNull
    @ApiModelProperty(value="The AWS region to create a new S3 bucket in or an existing S3 bucket's region", example="DEFAULT", required=true)
    private final String region;
    @Valid
    @NotNull
    @ApiModelProperty(value="The name of the S3 bucket", required=true)
    private final String name;
    @ApiModelProperty(value="The S3 blob store (i.e S3 object) key prefix")
    private final String prefix;
    @Valid
    @NotNull
    @ApiModelProperty(value="How many days until deleted blobs are finally removed from the S3 bucket (-1 to disable)", example="3")
    private final Integer expiration;

    @JsonCreator
    public S3BlobStoreApiBucket(@JsonProperty(value="region") String region, @JsonProperty(value="name") String name, @JsonProperty(value="prefix") String prefix, @JsonProperty(value="expiration") Integer expiration) {
        this.region = region;
        this.name = name;
        this.prefix = prefix;
        this.expiration = expiration;
    }

    public String getRegion() {
        return this.region;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Integer getExpiration() {
        return this.expiration;
    }
}

