/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.rest.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.s3.rest.internal.model.S3BlobStoreApiModel;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class S3BlobStoreApiUpdateValidation {
    private static final String BLOB_STORE_NAME = "name";
    private static final String COMMA = ",";
    private final BlobStoreManager blobStoreManager;

    @Inject
    public S3BlobStoreApiUpdateValidation(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    void validateCreateRequest(S3BlobStoreApiModel s3BlobStoreApiModel) {
        ArrayList<String> errors = new ArrayList<String>();
        this.checkBlobStoreNameNotEmpty(s3BlobStoreApiModel.getName(), errors);
        if (!errors.isEmpty()) {
            throw new ValidationErrorsException(BLOB_STORE_NAME, String.join((CharSequence)COMMA, errors));
        }
    }

    void validateUpdateRequest(S3BlobStoreApiModel s3BlobStoreApiModel, String blobStoreName) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean blobStoreExists = this.checkBlobStoreExists(blobStoreName, errors);
        this.checkBlobStoreNamesMatch(s3BlobStoreApiModel, blobStoreName, errors);
        if (blobStoreExists) {
            this.checkBlobStoreTypeIsS3(blobStoreName, errors);
        }
        if (!errors.isEmpty()) {
            throw new ValidationErrorsException(BLOB_STORE_NAME, String.join((CharSequence)COMMA, errors));
        }
    }

    private void checkBlobStoreNameNotEmpty(String blobStoreName, List<String> errors) {
        if (StringUtils.isBlank((String)blobStoreName)) {
            errors.add("Blob store name cannot be empty");
        }
    }

    private boolean checkBlobStoreExists(String blobStoreName, List<String> errors) {
        if (!this.blobStoreManager.exists(blobStoreName)) {
            errors.add(String.format("No S3 blob store called '%s'", blobStoreName));
            return false;
        }
        return true;
    }

    private void checkBlobStoreNamesMatch(S3BlobStoreApiModel s3BlobStoreApiModel, String blobStoreName, List<String> errors) {
        if (!StringUtils.equalsIgnoreCase((String)s3BlobStoreApiModel.getName(), (String)blobStoreName)) {
            errors.add("Renaming an S3 blob store name is not supported");
        }
    }

    private void checkBlobStoreTypeIsS3(String blobStoreName, List<String> errors) {
        if (this.existingBlobStoreIsNotS3(blobStoreName)) {
            errors.add(String.format("Blob store %s is not an S3 blob store", blobStoreName));
        }
    }

    private boolean existingBlobStoreIsNotS3(String blobStoreName) {
        return !Optional.ofNullable(this.blobStoreManager.get(blobStoreName)).map(BlobStore::getBlobStoreConfiguration).map(BlobStoreConfiguration::getType).filter(type -> StringUtils.equalsIgnoreCase((String)"S3", (String)type)).isPresent();
    }
}

