/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal.ui;

import com.amazonaws.services.s3.model.Region;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.blobstore.s3.internal.ui.S3EncryptionTypeXO;
import org.sonatype.nexus.blobstore.s3.internal.ui.S3RegionXO;
import org.sonatype.nexus.blobstore.s3.internal.ui.S3SignerTypeXO;
import org.sonatype.nexus.extdirect.DirectComponentSupport;

@Named
@Singleton
@DirectAction(action={"s3_S3"})
public class S3Component
extends DirectComponentSupport {
    private static final String DEFAULT_LABEL = "Default";
    private static final String S3_SIGNER = "S3SignerType";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    private final List<S3RegionXO> regions = new ArrayList<S3RegionXO>();
    private final List<S3SignerTypeXO> signerTypes;
    private final List<S3EncryptionTypeXO> encryptionTypes;

    public S3Component() {
        this.regions.add(new S3RegionXO().withOrder(0).withId("DEFAULT").withName(DEFAULT_LABEL));
        IntStream.range(0, Region.values().length).mapToObj(index -> {
            Region item = Region.values()[index];
            return new S3RegionXO().withOrder(index + 1).withId(item.toAWSRegion().getName()).withName(item.toAWSRegion().getName());
        }).forEach(s3RegionXO -> {
            boolean bl = this.regions.add((S3RegionXO)s3RegionXO);
        });
        this.signerTypes = Arrays.asList(new S3SignerTypeXO().withOrder(0).withId("DEFAULT").withName(DEFAULT_LABEL), new S3SignerTypeXO().withOrder(1).withId(S3_SIGNER).withName(S3_SIGNER), new S3SignerTypeXO().withOrder(2).withId(S3_V4_SIGNER).withName(S3_V4_SIGNER));
        this.encryptionTypes = Arrays.asList(new S3EncryptionTypeXO().withOrder(0).withId("none").withName("None"), new S3EncryptionTypeXO().withOrder(1).withId("s3ManagedEncryption").withName("S3 Managed Encryption"), new S3EncryptionTypeXO().withOrder(2).withId("kmsManagedEncryption").withName("KMS Managed Encryption"));
    }

    public List<S3RegionXO> getRegions() {
        return this.regions;
    }

    public List<S3SignerTypeXO> getSignerTypes() {
        return this.signerTypes;
    }

    public List<S3EncryptionTypeXO> getEncryptionTypes() {
        return this.encryptionTypes;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:settings:read"})
    public List<S3RegionXO> regions() {
        return this.regions;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:settings:read"})
    public List<S3SignerTypeXO> signertypes() {
        return this.signerTypes;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:settings:read"})
    public List<S3EncryptionTypeXO> encryptionTypes() {
        return this.encryptionTypes;
    }
}

