/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal.datastore;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.BlobStoreMetricsPropertiesReaderSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStore;
import org.sonatype.nexus.blobstore.s3.internal.S3PropertiesFile;

@Named(value="S3")
@Singleton
public class S3BlobStoreMetricsPropertiesReader
extends BlobStoreMetricsPropertiesReaderSupport<S3PropertiesFile> {
    private static final Map<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)"s3", (Object)Long.MAX_VALUE);
    private S3Config s3Configuration;

    public void initWithBlobStore(BlobStore blobStore) throws Exception {
        if (!(blobStore instanceof S3BlobStore)) {
            throw new IllegalArgumentException("BlobStore must be of type S3BlobStore");
        }
        S3BlobStore s3BlobStore = (S3BlobStore)blobStore;
        s3BlobStore.useAmazonS3Config(s3Config -> {
            S3Config s3Config2 = this.s3Configuration = s3Config;
        });
    }

    protected S3PropertiesFile getProperties() throws Exception {
        String bucket = this.s3Configuration.getBucket();
        Optional<String> key = this.s3Configuration.getS3().listObjects(bucket).getObjectSummaries().stream().filter(summary -> summary.getKey().endsWith(this.metricsFilename())).findFirst().map(S3ObjectSummary::getKey);
        return key.map(metricsKey -> new S3PropertiesFile(this.s3Configuration.getS3(), bucket, (String)metricsKey)).orElse(null);
    }

    protected Map<String, Long> getAvailableSpace() throws Exception {
        return AVAILABLE_SPACE_BY_FILE_STORE;
    }

    public static final class S3Config {
        private final AmazonS3 s3;
        private final String bucket;

        public S3Config(AmazonS3 s3, String bucket) {
            this.s3 = (AmazonS3)Preconditions.checkNotNull((Object)s3);
            this.bucket = (String)Preconditions.checkNotNull((Object)bucket);
        }

        public AmazonS3 getS3() {
            return this.s3;
        }

        public String getBucket() {
            return this.bucket;
        }
    }
}

