/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal.datastore;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsEntity;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsStore;
import org.sonatype.nexus.blobstore.metrics.DatastoreBlobStoreMetricsServiceSupport;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStoreMetricsService;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
@Priority(value=0x7FFFFFFF)
public class DatastoreS3BlobStoreMetricsService
extends DatastoreBlobStoreMetricsServiceSupport
implements S3BlobStoreMetricsService {
    private static final ImmutableMap<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)"s3", (Object)Long.MAX_VALUE);

    @Inject
    public DatastoreS3BlobStoreMetricsService(@Named(value="${nexus.blobstore.metrics.flushInterval:-2}") @Named(value="${nexus.blobstore.metrics.flushInterval:-2}") int metricsFlushPeriodSeconds, BlobStoreMetricsStore blobStoreMetricsStore, PeriodicJobService jobService) {
        super(metricsFlushPeriodSeconds, jobService, blobStoreMetricsStore);
    }

    public BlobStoreMetrics getMetrics() {
        BlobStoreMetricsEntity metricsEntity = this.blobStoreMetricsStore.get(this.blobStore.getBlobStoreConfiguration().getName());
        return new AccumulatingBlobStoreMetrics(metricsEntity.getBlobCount(), metricsEntity.getTotalSize(), AVAILABLE_SPACE_BY_FILE_STORE, true);
    }

    @Override
    public void setBucket(String configuredBucket) {
    }

    @Override
    public void setBucketPrefix(String bucketPrefix) {
    }

    @Override
    public void setS3(AmazonS3 s3) {
    }
}

