/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.CloudBlobPropertiesSupport;

public class S3PropertiesFile
extends CloudBlobPropertiesSupport<ObjectMetadata> {
    private static final Logger log = LoggerFactory.getLogger(S3PropertiesFile.class);
    private final AmazonS3 s3;
    private final String bucket;
    private final String key;

    public S3PropertiesFile(AmazonS3 s3, String bucket, String key) {
        this.s3 = (AmazonS3)Preconditions.checkNotNull((Object)s3);
        this.bucket = (String)Preconditions.checkNotNull((Object)bucket);
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public void load() throws IOException {
        log.debug("Loading: {}/{}", (Object)this.bucket, (Object)this.key);
        Throwable throwable = null;
        Object var2_3 = null;
        try (S3Object object = this.s3.getObject(this.bucket, this.key);){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (S3ObjectInputStream inputStream = object.getObjectContent();){
                this.load((InputStream)inputStream);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public ObjectMetadata getMetadata() {
        ObjectMetadata metadata = new ObjectMetadata();
        this.maybePutTempBlobUserMetadata(metadata);
        return metadata;
    }

    public ByteArrayOutputStream getData() throws IOException {
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        this.store(bufferStream, null);
        return bufferStream;
    }

    protected void write(ByteArrayOutputStream data, ObjectMetadata metadata) {
        log.debug("Storing: {}/{}", (Object)this.bucket, (Object)this.key);
        byte[] buffer = data.toByteArray();
        metadata.setContentLength((long)buffer.length);
        this.s3.putObject(this.bucket, this.key, new ByteArrayInputStream(buffer), metadata);
    }

    private void maybePutTempBlobUserMetadata(ObjectMetadata metadata) {
        if (this.containsKey("@BlobStore.temporary-blob")) {
            metadata.addUserMetadata("BlobStore.temporary-blob", "true");
        }
    }

    public boolean exists() throws IOException {
        return this.s3.doesObjectExist(this.bucket, this.key);
    }

    public void remove() throws IOException {
        this.s3.deleteObject(this.bucket, this.key);
    }

    public String toString() {
        return String.format("s3://%s/%s %s", this.bucket, this.key, super.toString());
    }

    public boolean equals(Object object) {
        if (object instanceof S3PropertiesFile) {
            S3PropertiesFile other = (S3PropertiesFile)((Object)object);
            return this.s3.equals(other.s3) && this.bucket.equals(other.bucket) && this.key.equals(other.key) && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.s3.hashCode() + this.bucket.hashCode() + this.key.hashCode() + super.hashCode();
    }
}

