/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStoreException;

public class S3BlobStoreException
extends BlobStoreException {
    public static final String DEFAULT_MESSAGE = "An unexpected S3 error occurred. Check the logs for more details.";
    public static final String INSUFFICIENT_PERM_CREATE_BUCKET_ERR_MSG = "Insufficient permissions to create bucket.";
    public static final String UNEXPECTED_ERR = "An unexpected error occurred %s. Check the logs for more details.";
    public static final String BUCKET_OWNERSHIP_ERR_MSG = "Bucket exists but is not owned by you.";
    public static final String INVALID_IDENTITY_ERR_MSG = "The identity used does not belong to the bucket owner's account.";
    public static final String ACCESS_DENIED_CODE = "AccessDenied";
    public static final String METHOD_NOT_ALLOWED_CODE = "MethodNotAllowed";
    public static final String INVALID_ACCESS_KEY_ID_CODE = "InvalidAccessKeyId";
    public static final String SIGNATURE_DOES_NOT_MATCH_CODE = "SignatureDoesNotMatch";
    public static Map<String, String> ERROR_CODE_MESSAGES = ImmutableMap.of((Object)"InvalidAccessKeyId", (Object)"The Access Key ID provided was invalid.", (Object)"AccessDenied", (Object)"Access denied. Please check the credentials provided have proper permissions.", (Object)"SignatureDoesNotMatch", (Object)"The secret access key does not match causing an invalid signature.");
    private final String message;

    private S3BlobStoreException(String message, Throwable cause, @Nullable BlobId blobId) {
        super(message, cause, blobId);
        this.message = message;
    }

    private S3BlobStoreException(String message) {
        super(message, null);
        this.message = message;
    }

    public static S3BlobStoreException buildException(AmazonS3Exception cause) {
        String message = ERROR_CODE_MESSAGES.getOrDefault(cause.getErrorCode(), DEFAULT_MESSAGE);
        return new S3BlobStoreException(message, cause, null);
    }

    public static S3BlobStoreException insufficientCreatePermissionsError() {
        return new S3BlobStoreException(INSUFFICIENT_PERM_CREATE_BUCKET_ERR_MSG);
    }

    public static S3BlobStoreException unexpectedError(String action) {
        return new S3BlobStoreException(String.format(UNEXPECTED_ERR, action));
    }

    public static S3BlobStoreException bucketOwnershipError() {
        return new S3BlobStoreException(BUCKET_OWNERSHIP_ERR_MSG);
    }

    public static S3BlobStoreException invalidIdentityError() {
        return new S3BlobStoreException(INVALID_IDENTITY_ERR_MSG);
    }

    public String getMessage() {
        return this.message;
    }
}

