/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

public class S3BlobStoreConfigurationHelper {
    private S3BlobStoreConfigurationHelper() {
    }

    public static void setConfiguredBucket(BlobStoreConfiguration blobStoreConfiguration, String bucket) {
        blobStoreConfiguration.attributes("s3").set("bucket", (Object)bucket);
    }

    public static String getConfiguredBucket(BlobStoreConfiguration blobStoreConfiguration) {
        return blobStoreConfiguration.attributes("s3").require("bucket").toString();
    }

    public static int getConfiguredExpirationInDays(BlobStoreConfiguration blobStoreConfiguration) {
        return Integer.parseInt(blobStoreConfiguration.attributes("s3").get("expiration", (Object)3).toString());
    }

    public static String getBucketPrefix(BlobStoreConfiguration blobStoreConfiguration) {
        return Optional.ofNullable((String)blobStoreConfiguration.attributes("s3").get("prefix", String.class)).filter((Predicate<String>)Predicates.not(Strings::isNullOrEmpty)).map(s -> String.valueOf(s.replaceFirst("/$", "")) + "/").orElse("");
    }
}

