/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStore;
import org.sonatype.nexus.blobstore.s3.internal.S3Uploader;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.jmx.reflect.ManagedOperation;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Singleton
@ManagedObject
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Named(value="producerConsumerUploader")
public class ProducerConsumerUploader
extends StateGuardLifecycleSupport
implements S3Uploader {
    private static final String METRIC_NAME = "uploader";
    private static final PartETag POISON_TAG = new PartETag(Integer.MIN_VALUE, "failure");
    private static final ChunkReader.Chunk EMPTY_CHUNK = new ChunkReader.Chunk(0, new byte[0], 0);
    private final int chunkSize;
    private final int threadCount;
    private final Timer readChunk;
    private final Timer uploadChunk;
    private final Timer multipartUpload;
    private final BlockingQueue<UploadBundle> waitingRequests;
    private ExecutorService executorService;

    @Inject
    public ProducerConsumerUploader(@Named(value="${nexus.s3.producerConsumerUploader.chunksize:-10485760}") @Named(value="${nexus.s3.producerConsumerUploader.chunksize:-10485760}") int chunkSize, @Named(value="${nexus.s3.producerConsumerUploader.parallelism:-0}") @Named(value="${nexus.s3.producerConsumerUploader.parallelism:-0}") int numberOfThreads, MetricRegistry registry) {
        Preconditions.checkArgument((numberOfThreads >= 0 ? 1 : 0) != 0, (Object)"Must use a non-negative parallelism");
        Preconditions.checkArgument((chunkSize >= 0 ? 1 : 0) != 0, (Object)"Must use a non-negative chunkSize");
        this.chunkSize = chunkSize;
        this.threadCount = numberOfThreads > 0 ? numberOfThreads : Runtime.getRuntime().availableProcessors();
        this.waitingRequests = new LinkedBlockingQueue<UploadBundle>(this.threadCount);
        this.readChunk = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "readChunk"}));
        this.uploadChunk = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "uploadChunk"}));
        this.multipartUpload = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "multiPartUpload"}));
    }

    protected void doStart() {
        this.executorService = Executors.newFixedThreadPool(this.threadCount, (ThreadFactory)new NexusThreadFactory("s3-parallel", "producerConsumerThreads"));
        int workerCount = 0;
        while (workerCount < this.threadCount) {
            this.executorService.submit(new ChunkUploader(this.waitingRequests));
            ++workerCount;
        }
    }

    protected void doStop() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    @ManagedOperation(description="Restarts the uploader with a new threadpool")
    public void bounce() throws Exception {
        this.log.debug("Bouncing ProducerConsumerUploader");
        this.stop();
        this.start();
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public void upload(AmazonS3 s3, String bucket, String key, InputStream contents) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedInputStream input = new BufferedInputStream(contents, this.chunkSize);){
                this.log.debug("Starting upload to key {} in bucket {}", (Object)key, (Object)bucket);
                ((InputStream)input).mark(this.chunkSize);
                ChunkReader firstReader = new ChunkReader(input, this.readChunk);
                ChunkReader.Chunk firstChunk = firstReader.readChunk(this.chunkSize).orElse(EMPTY_CHUNK);
                ((InputStream)input).reset();
                if (firstChunk.dataLength < this.chunkSize) {
                    ObjectMetadata metadata = new ObjectMetadata();
                    metadata.setContentLength((long)firstChunk.dataLength);
                    s3.putObject(bucket, key, new ByteArrayInputStream(firstChunk.data, 0, firstChunk.dataLength), metadata);
                } else {
                    InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(bucket, key);
                    String uploadId = s3.initiateMultipartUpload(initiateRequest).getUploadId();
                    try {
                        Throwable throwable2 = null;
                        Object var13_19 = null;
                        try (Timer.Context uploadContext = this.multipartUpload.time();){
                            List<PartETag> partETags = this.submitPartUploads(input, bucket, key, uploadId, s3);
                            s3.completeMultipartUpload(new CompleteMultipartUploadRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartETags(partETags));
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, uploadId));
                        Thread.currentThread().interrupt();
                    }
                    catch (SdkBaseException | CancellationException ex) {
                        s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, key, uploadId));
                        throw new BlobStoreException(String.format("Error executing parallel requests for bucket:%s key:%s with uploadId:%s", bucket, key, uploadId), ex, null);
                    }
                }
                this.log.debug("Finished upload to key {} in bucket {}", (Object)key, (Object)bucket);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SdkClientException | IOException e) {
            throw new BlobStoreException(String.format("Error uploading blob to bucket:%s key:%s", bucket, key), e, null);
        }
    }

    private List<PartETag> submitPartUploads(InputStream input, String bucket, String key, String uploadId, AmazonS3 s3) throws IOException, InterruptedException {
        Optional<ChunkReader.Chunk> optionalChunk;
        LinkedBlockingQueue<PartETag> tags = new LinkedBlockingQueue<PartETag>();
        ChunkReader parallelReader = new ChunkReader(input, this.readChunk);
        int chunkCount = 0;
        while ((optionalChunk = parallelReader.readChunk(this.chunkSize)).isPresent()) {
            ChunkReader.Chunk chunk = optionalChunk.get();
            ++chunkCount;
            UploadPartRequest request = this.buildRequest(bucket, key, uploadId, chunk);
            this.waitingRequests.put(new UploadBundle(s3, request, tags));
        }
        ArrayList<PartETag> partETags = new ArrayList<PartETag>(chunkCount);
        int idx = 0;
        while (idx < chunkCount) {
            PartETag partETag = (PartETag)tags.take();
            if (partETag == POISON_TAG) {
                throw new CancellationException("Part upload failed");
            }
            partETags.add(partETag);
            ++idx;
        }
        return partETags;
    }

    private UploadPartRequest buildRequest(String bucket, String key, String uploadId, ChunkReader.Chunk chunk) {
        return new UploadPartRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartNumber(chunk.chunkNumber).withInputStream((InputStream)new ByteArrayInputStream(chunk.data, 0, chunk.dataLength)).withPartSize((long)chunk.dataLength);
    }

    public static class ChunkReader {
        private final AtomicInteger counter = new AtomicInteger(1);
        private final InputStream input;
        private final Timer readChunk;

        public ChunkReader(InputStream input, Timer readTimer) {
            this.input = (InputStream)Preconditions.checkNotNull((Object)input);
            this.readChunk = (Timer)Preconditions.checkNotNull((Object)readTimer);
        }

        synchronized Optional<Chunk> readChunk(int size) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Timer.Context readContext = this.readChunk.time();){
                int readSize;
                byte[] buf = new byte[size];
                int bytesRead = 0;
                while ((readSize = this.input.read(buf, bytesRead, size - bytesRead)) != -1 && bytesRead < size) {
                    bytesRead += readSize;
                }
                Optional<Chunk> optional = bytesRead > 0 ? Optional.of(new Chunk(bytesRead, buf, this.counter.getAndIncrement())) : Optional.empty();
                return optional;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        static class Chunk {
            final byte[] data;
            final int dataLength;
            final int chunkNumber;

            Chunk(int dataLength, byte[] data, int chunkNumber) {
                this.dataLength = dataLength;
                this.data = data;
                this.chunkNumber = chunkNumber;
            }
        }
    }

    private class ChunkUploader
    implements Runnable {
        private final BlockingQueue<UploadBundle> bundles;

        ChunkUploader(BlockingQueue<UploadBundle> bundles) {
            this.bundles = bundles;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        UploadBundle bundle = this.bundles.take();
                        AmazonS3 s3 = bundle.s3;
                        BlockingQueue<PartETag> tags = bundle.tags;
                        UploadPartRequest request = bundle.request;
                        try {
                            Throwable throwable = null;
                            Object var6_8 = null;
                            try {
                                Timer.Context uploadContext = ProducerConsumerUploader.this.uploadChunk.time();
                                try {
                                    tags.put(s3.uploadPart(request).getPartETag());
                                    continue;
                                }
                                finally {
                                    if (uploadContext == null) continue;
                                    uploadContext.close();
                                    continue;
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            ProducerConsumerUploader.this.log.error("Error uploading part of multipart upload", (Throwable)ex);
                            tags.put(POISON_TAG);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    ProducerConsumerUploader.this.log.debug("Interrupted while uploading a request");
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    public static class UploadBundle {
        public final AmazonS3 s3;
        public final UploadPartRequest request;
        public final BlockingQueue<PartETag> tags;

        public UploadBundle(AmazonS3 s3, UploadPartRequest request, BlockingQueue<PartETag> tags) {
            this.s3 = s3;
            this.request = request;
            this.tags = tags;
        }
    }
}

