/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.s3.internal.ParallelRequester;
import org.sonatype.nexus.blobstore.s3.internal.S3Uploader;

@Singleton
@Named(value="parallelUploader")
public class ParallelUploader
extends ParallelRequester
implements S3Uploader {
    private static final ChunkReader.Chunk EMPTY_CHUNK = new ChunkReader.Chunk(0, new byte[0], 0);

    @Inject
    public ParallelUploader(@Named(value="${nexus.s3.parallelRequests.chunksize:-5242880}") @Named(value="${nexus.s3.parallelRequests.chunksize:-5242880}") int chunkSize, @Named(value="${nexus.s3.parallelRequests.parallelism:-0}") @Named(value="${nexus.s3.parallelRequests.parallelism:-0}") int nThreads) {
        super(chunkSize, nThreads, "uploadThreads");
    }

    @Override
    public void upload(AmazonS3 s3, String bucket, String key, InputStream contents) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedInputStream input = new BufferedInputStream(contents, this.chunkSize);){
                this.log.debug("Starting upload to key {} in bucket {}", (Object)key, (Object)bucket);
                ((InputStream)input).mark(this.chunkSize);
                ChunkReader chunkReader = new ChunkReader(input);
                ChunkReader.Chunk chunk = chunkReader.readChunk(this.chunkSize).orElse(EMPTY_CHUNK);
                ((InputStream)input).reset();
                if (chunk.dataLength < this.chunkSize) {
                    ObjectMetadata metadata = new ObjectMetadata();
                    metadata.setContentLength((long)chunk.dataLength);
                    s3.putObject(bucket, key, new ByteArrayInputStream(chunk.data, 0, chunk.dataLength), metadata);
                } else {
                    ChunkReader parallelReader = new ChunkReader(input);
                    this.parallelRequests(s3, bucket, key, () -> uploadId -> this.uploadChunks(s3, bucket, key, (String)uploadId, parallelReader));
                }
                this.log.debug("Finished upload to key {} in bucket {}", (Object)key, (Object)bucket);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SdkClientException | IOException e) {
            throw new BlobStoreException(String.format("Error uploading blob to bucket:%s key:%s", bucket, key), e, null);
        }
    }

    private List<PartETag> uploadChunks(AmazonS3 s3, String bucket, String key, String uploadId, ChunkReader chunkReader) throws IOException {
        Optional<ChunkReader.Chunk> chunk;
        ArrayList<PartETag> tags = new ArrayList<PartETag>();
        while ((chunk = chunkReader.readChunk(this.chunkSize)).isPresent()) {
            UploadPartRequest request = new UploadPartRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartNumber(chunk.get().chunkNumber).withInputStream((InputStream)new ByteArrayInputStream(chunk.get().data, 0, chunk.get().dataLength)).withPartSize((long)chunk.get().dataLength);
            tags.add(s3.uploadPart(request).getPartETag());
        }
        return tags;
    }

    static class ChunkReader {
        private final AtomicInteger counter = new AtomicInteger(1);
        private final InputStream input;

        private ChunkReader(InputStream input) {
            this.input = (InputStream)Preconditions.checkNotNull((Object)input);
        }

        synchronized Optional<Chunk> readChunk(int size) throws IOException {
            int readSize;
            byte[] buf = new byte[size];
            int bytesRead = 0;
            while ((readSize = this.input.read(buf, bytesRead, size - bytesRead)) != -1 && bytesRead < size) {
                bytesRead += readSize;
            }
            return bytesRead > 0 ? Optional.of(new Chunk(bytesRead, buf, this.counter.getAndIncrement())) : Optional.empty();
        }

        static class Chunk {
            final byte[] data;
            final int dataLength;
            final int chunkNumber;

            Chunk(int dataLength, byte[] data, int chunkNumber) {
                this.dataLength = dataLength;
                this.data = data;
                this.chunkNumber = chunkNumber;
            }
        }
    }
}

