/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.BlobStoreMetricsNotAvailableException;
import org.sonatype.nexus.blobstore.BlobStoreMetricsStoreSupport;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.s3.internal.S3PropertiesFile;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
public class OrientS3BlobStoreMetricsStore
extends BlobStoreMetricsStoreSupport<S3PropertiesFile>
implements S3BlobStoreMetricsService {
    static final ImmutableMap<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)"s3", (Object)Long.MAX_VALUE);
    private String bucket;
    private String bucketPrefix;
    private AmazonS3 s3;

    @Inject
    public OrientS3BlobStoreMetricsStore(PeriodicJobService jobService, NodeAccess nodeAccess) {
        super(nodeAccess, jobService);
    }

    protected S3PropertiesFile getProperties() {
        return new S3PropertiesFile(this.s3, this.bucket, String.valueOf(this.bucketPrefix) + this.nodeAccess.getId() + "-" + "metrics.properties");
    }

    protected AccumulatingBlobStoreMetrics getAccumulatingBlobStoreMetrics() {
        return new AccumulatingBlobStoreMetrics(0L, 0L, AVAILABLE_SPACE_BY_FILE_STORE, true);
    }

    protected Stream<S3PropertiesFile> backingFiles() throws BlobStoreMetricsNotAvailableException {
        try {
            if (this.s3 == null) {
                return Stream.empty();
            }
            return this.s3.listObjects(this.bucket, String.valueOf(this.bucketPrefix) + this.nodeAccess.getId()).getObjectSummaries().stream().filter(Objects::nonNull).filter(summary -> summary.getKey().endsWith("metrics.properties")).map(summary -> new S3PropertiesFile(this.s3, this.bucket, summary.getKey()));
        }
        catch (SdkClientException e) {
            throw new BlobStoreMetricsNotAvailableException((Throwable)e);
        }
    }

    @Override
    public void setBucket(String bucket) {
        Preconditions.checkNotNull((Object)bucket);
        this.bucket = bucket;
    }

    @Override
    public void setS3(AmazonS3 s3) {
        Preconditions.checkNotNull((Object)s3);
        this.s3 = s3;
    }

    @Override
    public void setBucketPrefix(String bucketPrefix) {
        Preconditions.checkNotNull((Object)bucketPrefix);
        this.bucketPrefix = bucketPrefix;
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return super.getOperationMetrics();
    }

    public void flush() throws IOException {
        super.flushProperties();
    }

    public void remove() {
        try {
            this.backingFiles().forEach(this::removeQuietly);
        }
        catch (BlobStoreMetricsNotAvailableException e) {
            this.log.warn("Unable to remove metrics files", (Throwable)e);
        }
    }

    private void removeQuietly(S3PropertiesFile file) {
        try {
            this.log.debug("Removing {}", (Object)file);
            file.remove();
        }
        catch (IOException e) {
            this.log.warn("Unable to remove metrics file {}", (Object)file, (Object)e);
        }
    }
}

