/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.s3.internal.S3Copier;

@Named(value="multipart-copier")
public class MultipartCopier
extends ComponentSupport
implements S3Copier {
    private final int chunkSize;

    @Inject
    public MultipartCopier(@Named(value="${nexus.s3.multipartupload.chunksize:-5242880}") @Named(value="${nexus.s3.multipartupload.chunksize:-5242880}") int chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public void copy(AmazonS3 s3, String bucket, String sourcePath, String destinationPath) {
        ObjectMetadata metadataResult = s3.getObjectMetadata(bucket, sourcePath);
        long length = metadataResult.getContentLength();
        try {
            if (length < (long)this.chunkSize) {
                this.copySinglePart(s3, bucket, sourcePath, destinationPath);
            } else {
                this.copyMultiPart(s3, bucket, sourcePath, destinationPath, length);
            }
        }
        catch (SdkClientException e) {
            throw new BlobStoreException("Error copying blob", (Throwable)e, null);
        }
    }

    private void copySinglePart(AmazonS3 s3, String bucket, String sourcePath, String destinationPath) {
        s3.copyObject(bucket, sourcePath, bucket, destinationPath);
    }

    private void copyMultiPart(AmazonS3 s3, String bucket, String sourcePath, String destinationPath, long length) {
        Preconditions.checkState((length > 0L ? 1 : 0) != 0);
        String uploadId = null;
        try {
            long remaining = length;
            long offset = 0L;
            InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(bucket, destinationPath);
            uploadId = s3.initiateMultipartUpload(initiateRequest).getUploadId();
            this.log.debug("Starting multipart copy {} to key {} from key {}", new Object[]{uploadId, destinationPath, sourcePath});
            ArrayList<CopyPartResult> results = new ArrayList<CopyPartResult>();
            int partNumber = 1;
            while (remaining > 0L) {
                long partSize = Math.min(remaining, (long)this.chunkSize);
                this.log.trace("Copying chunk {} for {} from byte {} to {}, size {}", new Object[]{partNumber, uploadId, offset, offset + partSize - 1L, partSize});
                CopyPartRequest part = new CopyPartRequest().withSourceBucketName(bucket).withSourceKey(sourcePath).withDestinationBucketName(bucket).withDestinationKey(destinationPath).withUploadId(uploadId).withPartNumber(partNumber).withFirstByte(Long.valueOf(offset)).withLastByte(Long.valueOf(offset + partSize - 1L));
                results.add(s3.copyPart(part));
                offset += partSize;
                remaining -= partSize;
                ++partNumber;
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest().withBucketName(bucket).withKey(destinationPath).withUploadId(uploadId).withPartETags(results.stream().map(r -> new PartETag(r.getPartNumber(), r.getETag())).collect(Collectors.toList()));
            s3.completeMultipartUpload(compRequest);
            this.log.debug("Copy {} complete", (Object)uploadId);
        }
        catch (SdkClientException e) {
            if (uploadId != null) {
                try {
                    s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucket, destinationPath, uploadId));
                }
                catch (Exception inner) {
                    this.log.error("Error aborting S3 multipart copy to bucket {} with key {}", new Object[]{bucket, destinationPath, this.log.isDebugEnabled() ? inner : null});
                }
            }
            throw e;
        }
    }
}

