/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientParams;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.SetObjectTaggingResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.InputStream;
import java.util.Optional;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.s3.internal.S3BlobStore;
import org.sonatype.nexus.blobstore.s3.internal.encryption.KMSEncrypter;
import org.sonatype.nexus.blobstore.s3.internal.encryption.NoEncrypter;
import org.sonatype.nexus.blobstore.s3.internal.encryption.S3Encrypter;
import org.sonatype.nexus.blobstore.s3.internal.encryption.S3ManagedEncrypter;

public class EncryptingAmazonS3Client
extends AmazonS3Client {
    private static final String METRIC_NAME = "encryptingS3Client";
    private final S3Encrypter encrypter;
    private final Timer getTimer;
    private final Timer putTimer;
    private final Timer copyTimer;
    private final Timer uploadPartTimer;
    private final Timer deleteTimer;
    private final Timer setTaggingTimer;

    public EncryptingAmazonS3Client(BlobStoreConfiguration blobStoreConfig, AmazonS3ClientParams s3ClientParams) {
        super(s3ClientParams);
        this.encrypter = this.getEncrypter(blobStoreConfig);
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"nexus");
        this.getTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "get"}));
        this.putTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "put"}));
        this.copyTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "copy"}));
        this.uploadPartTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "uploadPart"}));
        this.deleteTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "delete"}));
        this.setTaggingTimer = registry.timer(MetricRegistry.name(S3BlobStore.class, (String[])new String[]{METRIC_NAME, "setTagging"}));
    }

    private S3Encrypter getEncrypter(BlobStoreConfiguration blobStoreConfig) {
        Optional<String> encryptionType = Optional.ofNullable((String)blobStoreConfig.attributes("s3").get("encryption_type", String.class));
        return encryptionType.map(id -> {
            if ("s3ManagedEncryption".equals(id)) {
                return new S3ManagedEncrypter();
            }
            if ("kmsManagedEncryption".equals(id)) {
                Optional<String> key = Optional.ofNullable((String)blobStoreConfig.attributes("s3").get("encryption_key", String.class));
                return new KMSEncrypter(key);
            }
            if ("none".equals(id)) {
                return NoEncrypter.INSTANCE;
            }
            throw new IllegalStateException("Failed to find encrypter for id:" + id);
        }).orElse(NoEncrypter.INSTANCE);
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) {
        this.encrypter.addEncryption(request);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Timer.Context copyContext = this.copyTimer.time();){
            return super.copyObject(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) {
        this.encrypter.addEncryption(request);
        return super.initiateMultipartUpload(request);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) {
        return this.putObject(new PutObjectRequest(bucketName, key, file));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, String redirectLocation) {
        return this.putObject(new PutObjectRequest(bucketName, key, redirectLocation));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) {
        this.encrypter.addEncryption(request);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Timer.Context putContext = this.putTimer.time();){
            return super.putObject(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Timer.Context getContext = this.getTimer.time();){
            return super.getObject(getObjectRequest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public S3Object getObject(String bucketName, String key) {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Timer.Context uploadPartContext = this.uploadPartTimer.time();){
            return super.uploadPart(uploadPartRequest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void deleteObject(String bucketName, String key) {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Timer.Context deleteContext = this.deleteTimer.time();){
            super.deleteObject(deleteObjectRequest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Timer.Context setTaggingContext = this.setTaggingTimer.time();){
            return super.setObjectTagging(setObjectTaggingRequest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

