/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ORemoteConnectionPool;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OStorageRemoteAsynchEventListener
implements ORemoteServerEventListener {
    private Map<Integer, OLiveResultListener> liveQueryListeners = new ConcurrentHashMap<Integer, OLiveResultListener>();
    private ConcurrentMap<ORemoteConnectionPool, Set<Integer>> poolLiveQuery = new ConcurrentHashMap<ORemoteConnectionPool, Set<Integer>>();
    private OStorageRemote storage;

    public OStorageRemoteAsynchEventListener(OStorageRemote storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(byte iRequestCode, Object obj) {
        if (this.storage.getStatus() == OStorage.STATUS.CLOSED) {
            return;
        }
        if (iRequestCode == 80) {
            this.storage.updateClusterConfiguration(null, (byte[])obj);
            if (OLogManager.instance().isDebugEnabled()) {
                ODocument oDocument = this.storage.getClusterConfiguration();
                synchronized (oDocument) {
                    OLogManager.instance().debug((Object)this, "Received new cluster configuration: %s", new Object[]{this.storage.getClusterConfiguration().toJSON("prettyPrint")});
                }
            }
        } else if (iRequestCode == 81) {
            byte[] bytes = (byte[])obj;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            Integer id = null;
            try {
                byte what = dis.readByte();
                if (what == 114) {
                    byte op = dis.readByte();
                    id = dis.readInt();
                    ORecord record = Orient.instance().getRecordFactoryManager().newInstance(dis.readByte());
                    int version = this.readVersion(dis);
                    ORecordId rid = this.readRID(dis);
                    byte[] content = this.readBytes(dis);
                    ORecordInternal.fill((ORecord)record, (ORID)rid, (int)version, (byte[])content, (boolean)false);
                    OLiveResultListener listener = this.liveQueryListeners.get(id);
                    if (listener != null) {
                        listener.onLiveResult(id.intValue(), new ORecordOperation((OIdentifiable)record, op));
                    } else {
                        OLogManager.instance().warn((Object)this, "Receiving invalid LiveQuery token: " + id, new Object[0]);
                    }
                } else if (what == 117) {
                    id = dis.readInt();
                    OLiveResultListener listener = this.liveQueryListeners.get(id);
                    listener.onUnsubscribe(id.intValue());
                }
            }
            catch (IOException e) {
                OLiveResultListener listener;
                if (id != null && (listener = this.liveQueryListeners.get(id)) != null) {
                    listener.onError(id.intValue());
                }
                OLogManager.instance().error((Object)this, "Error during request processing", (Throwable)e, new Object[0]);
            }
        }
    }

    private int readVersion(DataInputStream dis) throws IOException {
        return dis.readInt();
    }

    private ORecordId readRID(DataInputStream dis) throws IOException {
        short clusterId = dis.readShort();
        long clusterPosition = dis.readLong();
        return new ORecordId((int)clusterId, clusterPosition);
    }

    public byte[] readBytes(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        in.readFully(tmp);
        return tmp;
    }

    public OStorageRemote getStorage() {
        return this.storage;
    }

    public void registerLiveListener(ORemoteConnectionPool pool, Integer id, OLiveResultListener listener) {
        Set prev;
        this.liveQueryListeners.put(id, listener);
        Set<Integer> res = (Set<Integer>)this.poolLiveQuery.get(pool);
        if (res == null && (prev = this.poolLiveQuery.putIfAbsent(pool, res = Collections.synchronizedSet(new HashSet()))) != null) {
            res = prev;
        }
        res.add(id);
    }

    public void unregisterLiveListener(Integer id) {
        this.liveQueryListeners.remove(id);
    }

    public void onEndUsedConnections(ORemoteConnectionPool pool) {
        Set res = (Set)this.poolLiveQuery.get(pool);
        if (res != null) {
            for (Integer query : res) {
                OLiveResultListener liveQuery = this.liveQueryListeners.remove(query);
                liveQuery.onError(query.intValue());
            }
        }
    }
}

