/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Mutex;
import org.sonatype.nexus.internal.wonderland.UserAuthToken;
import org.sonatype.nexus.wonderland.AuthTicketCache;

@Named
public class LocalAuthTicketCache
extends ComponentSupport
implements AuthTicketCache {
    private final Mutex lock = new Mutex();
    private final Map<UserAuthToken, Long> tokens = Maps.newHashMap();
    private final Duration expireAfter;

    @Inject
    public LocalAuthTicketCache(@Named(value="${wonderland.authTicketCache.expireAfter:-20s}") @Named(value="${wonderland.authTicketCache.expireAfter:-20s}") Duration expireAfter) {
        this.expireAfter = (Duration)Preconditions.checkNotNull((Object)expireAfter);
        this.log.debug("Expire after: {}", (Object)expireAfter);
    }

    @VisibleForTesting
    public LocalAuthTicketCache() {
        this(Duration.ofSeconds(2L));
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void expireTokens() {
        boolean trace = this.log.isTraceEnabled();
        long now = this.now();
        Iterator<Map.Entry<UserAuthToken, Long>> iter = this.tokens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UserAuthToken, Long> entry = iter.next();
            if (!this.isTokenExpired(now, entry)) continue;
            iter.remove();
            if (!trace) continue;
            this.log.trace("Expired token: {}", (Object)entry.getKey());
        }
        if (trace && !this.tokens.isEmpty()) {
            this.log.trace("Valid tokens:");
            for (Map.Entry<UserAuthToken, Long> entry : this.tokens.entrySet()) {
                this.log.trace("  {}", (Object)entry.getKey());
            }
        }
    }

    @VisibleForTesting
    protected boolean isTokenExpired(long now, Map.Entry<UserAuthToken, Long> entry) {
        long diff = now - entry.getValue();
        return diff > this.expireAfter.toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String user, String token, String realmName) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.expireTokens();
            UserAuthToken key = new UserAuthToken(user, token, realmName);
            Preconditions.checkState((!this.tokens.containsKey(key) ? 1 : 0) != 0, (Object)"Duplicate token");
            this.tokens.put(key, this.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String user, String token, String realmName) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.expireTokens();
            Long tmp = this.tokens.remove(new UserAuthToken(user, token, realmName));
            return tmp != null;
        }
    }
}

