/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.common.wonderland.DownloadService;

@Named(value="default")
@Singleton
public class DownloadServiceImpl
extends ComponentSupport
implements DownloadService {
    private static final AtomicLong counter = new AtomicLong();
    private final File downloadDir;
    private final AuthTicketService authTickets;

    @Inject
    public DownloadServiceImpl(ApplicationDirectories applicationDirectories, AuthTicketService authTicketService) {
        this.authTickets = (AuthTicketService)Preconditions.checkNotNull((Object)authTicketService);
        this.downloadDir = ((ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories)).getWorkDirectory("downloads");
        this.log.info("Downloads directory: {}", (Object)this.downloadDir);
    }

    public DownloadService.Download get(String fileName, String authTicket) throws IOException {
        this.log.info("Download: {}", (Object)fileName);
        if (!this.authTickets.redeemTicket(authTicket)) {
            throw new IllegalArgumentException("Invalid authentication ticket");
        }
        File file = new File(this.downloadDir, fileName);
        this.ensureWithinDownloads(file);
        if (!file.exists() && file.isFile()) {
            this.log.warn("File {} not found in download directory (or is not a file)", (Object)file);
            return null;
        }
        return new DownloadService.Download(file.length(), (InputStream)new FileInputStream(file));
    }

    public String move(File source, String name) throws IOException {
        File target = new File(this.downloadDir, name);
        this.ensureWithinDownloads(target);
        Files.move(source.toPath(), target.toPath(), new CopyOption[0]);
        this.log.debug("Moved {} to {}", (Object)source, (Object)target);
        return target.getAbsolutePath();
    }

    public String uniqueName(String prefix) {
        return String.valueOf(prefix) + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "-" + counter.incrementAndGet();
    }

    private void ensureWithinDownloads(File file) {
        Preconditions.checkArgument((boolean)file.getParentFile().equals(this.downloadDir), (Object)("Reference outside of downloads dir: " + file));
    }
}

