/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.internal.wonderland.AuthTicketGenerator;
import org.sonatype.nexus.wonderland.AuthTicketCache;

@Named
@Singleton
public class AuthTicketServiceImpl
extends ComponentSupport
implements AuthTicketService {
    private final AuthTicketGenerator authTicketGenerator;
    private final AuthTicketCache authTicketCache;

    @Inject
    public AuthTicketServiceImpl(AuthTicketGenerator authTicketGenerator, AuthTicketCache authTicketCache) {
        this.authTicketGenerator = (AuthTicketGenerator)((Object)Preconditions.checkNotNull((Object)((Object)authTicketGenerator)));
        this.authTicketCache = (AuthTicketCache)Preconditions.checkNotNull((Object)authTicketCache);
    }

    public String createTicket(String user, String realmName) {
        String ticket = this.authTicketGenerator.generate();
        this.authTicketCache.add(user, ticket, realmName);
        return ticket;
    }

    @Nullable
    public String createTicket() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Optional realmName = subject.getPrincipals().getRealmNames().stream().findFirst();
            return this.createTicket(subject.getPrincipal().toString(), realmName.orElse(null));
        }
        return null;
    }

    public boolean redeemTicket(String user, String ticket, String realmName) {
        Preconditions.checkNotNull((Object)ticket);
        return this.authTicketCache.remove(user, ticket, realmName);
    }

    public boolean redeemTicket(String ticket) {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Optional realmName = subject.getPrincipals().getRealmNames().stream().findFirst();
            return this.redeemTicket(subject.getPrincipal().toString(), ticket, realmName.orElse(null));
        }
        return false;
    }
}

