/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.webresources;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.servlet.ServletHelper;
import org.sonatype.nexus.servlet.XFrameOptions;
import org.sonatype.nexus.webresources.WebResource;
import org.sonatype.nexus.webresources.WebResourceService;

@Singleton
@Named
public class WebResourceServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(WebResourceServlet.class);
    private final WebResourceService webResources;
    private final long maxAgeSeconds;
    private final XFrameOptions xframeOptions;
    private static final String INDEX_PATH = "/index.html";

    @Inject
    public WebResourceServlet(WebResourceService webResources, XFrameOptions xframeOptions, @Named(value="${nexus.webresources.maxAge:-30days}") @Named(value="${nexus.webresources.maxAge:-30days}") Time maxAge) {
        this.webResources = (WebResourceService)Preconditions.checkNotNull((Object)webResources);
        this.maxAgeSeconds = (Long)Preconditions.checkNotNull((Object)maxAge.toSeconds());
        this.xframeOptions = (XFrameOptions)Preconditions.checkNotNull((Object)xframeOptions);
        log.info("Max-age: {} ({} seconds)", (Object)maxAge, (Object)this.maxAgeSeconds);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if ("".equals(path) || "/".equals(path)) {
            path = INDEX_PATH;
        } else if (path.endsWith("/")) {
            path = String.valueOf(path) + "index.html";
        } else if (INDEX_PATH.equals(path)) {
            response.sendRedirect(BaseUrlHolder.getRelativePath());
            return;
        }
        WebResource resource = this.webResources.getResource(path);
        if (resource == null) {
            if (this.webResources.getResource(String.valueOf(path) + INDEX_PATH) != null) {
                String location = String.format("%s%s/", BaseUrlHolder.getRelativePath(), path);
                log.debug("Redirecting: {} -> {}", (Object)path, (Object)location);
                response.sendRedirect(location);
            } else {
                response.sendError(404);
            }
            return;
        }
        this.serveResource(resource, request, response);
    }

    private void serveResource(WebResource resource, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.trace("Serving resource: {}", (Object)resource);
        response.setHeader("X-Frame-Options", this.xframeOptions.getValueForPath(request.getPathInfo()));
        response.setHeader("X-XSS-Protection", "1; mode=block");
        if (resource instanceof WebResource.Prepareable) {
            Preconditions.checkState(((resource = ((WebResource.Prepareable)resource).prepare()) != null ? 1 : 0) != 0, (Object)"Prepared resource is null");
        }
        Preconditions.checkNotNull((Object)resource);
        String contentType = resource.getContentType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.setHeader("Content-Type", contentType);
        response.setDateHeader("Last-Modified", resource.getLastModified());
        long size = resource.getSize();
        if (size < 0L) {
            log.warn("Resource {} has invalid size: {}", (Object)resource.getPath(), (Object)size);
        }
        response.setHeader("Content-Length", String.valueOf(size));
        if (resource.isCacheable()) {
            response.setHeader("Cache-Control", "max-age=" + this.maxAgeSeconds);
        } else {
            ServletHelper.addNoCacheResponseHeaders((HttpServletResponse)response);
        }
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince > -1L && resource.getLastModified() <= ifModifiedSince) {
            response.setStatus(304);
        } else if ("GET".equalsIgnoreCase(request.getMethod())) {
            Throwable throwable = null;
            Object var10_9 = null;
            try (InputStream in = resource.getInputStream();){
                ServletHelper.sendContent((InputStream)in, (HttpServletResponse)response);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

