/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.web;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.text.Strings2;

@Named
@Singleton
public class ThrowServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ThrowServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Type type = Type.parse(request.getParameter("type"));
        String message = request.getParameter("message");
        log.info("Throwing {} w/message: {}", (Object)type, (Object)message);
        switch (type) {
            case RUNTIME: {
                throw new RuntimeException(message);
            }
            case IO: {
                throw new IOException(message);
            }
            case SERVLET: {
                throw new ServletException(message);
            }
        }
        throw new Error(message);
    }

    private static enum Type {
        RUNTIME,
        ERROR,
        IO,
        SERVLET;


        static Type parse(String value) {
            if (value == null) {
                return RUNTIME;
            }
            return Type.valueOf(Strings2.upper((String)value));
        }
    }
}

