/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.web;

import com.google.common.base.Preconditions;
import com.google.inject.OutOfScopeException;
import com.google.inject.ProvisionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.security.ClientInfoProvider;
import org.sonatype.nexus.security.UserIdHelper;

@Named
@Singleton
public class ClientInfoProviderImpl
implements ClientInfoProvider {
    private final Provider<HttpServletRequest> httpRequestProvider;
    private final ThreadLocal<String> remoteIp = new ThreadLocal();
    private final ThreadLocal<String> userId = new ThreadLocal();

    @Inject
    public ClientInfoProviderImpl(Provider<HttpServletRequest> httpRequestProvider) {
        this.httpRequestProvider = (Provider)Preconditions.checkNotNull(httpRequestProvider);
    }

    @Nullable
    public ClientInfo getCurrentThreadClientInfo() {
        try {
            HttpServletRequest request = (HttpServletRequest)this.httpRequestProvider.get();
            return ClientInfo.builder().userId(UserIdHelper.get()).remoteIP(request.getRemoteAddr()).userAgent(request.getHeader("User-Agent")).path(request.getServletPath()).build();
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            return this.userId.get() != null && this.remoteIp.get() != null ? ClientInfo.builder().userId(this.userId.get()).remoteIP(this.remoteIp.get()).build() : null;
        }
    }

    public void setClientInfo(String remoteIp, String userId) {
        this.remoteIp.set((String)Preconditions.checkNotNull((Object)remoteIp));
        this.userId.set((String)Preconditions.checkNotNull((Object)userId));
    }

    public void unsetClientInfo() {
        this.remoteIp.remove();
        this.userId.remove();
    }
}

