/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.template;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.velocity.app.VelocityEngine;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class VelocityEngineProvider
extends ComponentSupport
implements Provider<VelocityEngine> {
    private final VelocityEngine engine = this.create();

    @Inject
    public VelocityEngineProvider() {
    }

    public VelocityEngine get() {
        return this.engine;
    }

    private VelocityEngine create() {
        VelocityEngine engine = new VelocityEngine();
        Joiner j = Joiner.on((char)'.');
        engine.setProperty("velocimacro.library.path", (Object)"");
        engine.setProperty("resource.loaders", (Object)"class");
        engine.setProperty(j.join((Object)"resource.loaders", (Object)"class", new Object[]{"class"}), (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        engine.setProperty(j.join((Object)"resource.loaders", (Object)"class", new Object[]{"cache"}), (Object)"true");
        engine.setProperty(j.join((Object)"resource.loaders", (Object)"class", new Object[]{"modification_check_interval"}), (Object)"0");
        engine.setProperty("runtime.strict_mode.enable", (Object)"false");
        engine.setProperty("velocimacro.inline.local_scope", (Object)"true");
        this.log.debug("Initializing: {}", (Object)engine);
        try {
            engine.init();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return engine;
    }
}

