/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="security", from="1.3", to="1.4")
public class SecurityDatabaseUpgrade_1_4
extends DatabaseUpgradeSupport {
    static final String DB_CLASS = new OClassNameBuilder().type("saml_user").build();
    private static final String QUERY = String.format("DELETE FROM %s WHERE id = ''", DB_CLASS);
    private final Provider<DatabaseInstance> securityDatabaseInstance;

    @Inject
    public SecurityDatabaseUpgrade_1_4(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
    }

    public void apply() {
        SecurityDatabaseUpgrade_1_4.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_CLASS, (db, type) -> {
            int updates = (Integer)db.command((OCommandRequest)new OCommandSQL(QUERY)).execute(new Object[0]);
            if (updates > 0) {
                this.log.debug("Deleted {} saml users with empty id.", (Object)updates);
            }
        });
    }
}

