/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.realm;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.security.realm.RealmConfigurationChangedEvent;
import org.sonatype.nexus.internal.security.realm.RealmConfigurationDAO;
import org.sonatype.nexus.internal.security.realm.RealmConfigurationData;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmConfigurationStore;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class RealmConfigurationStoreImpl
extends ConfigStoreSupport<RealmConfigurationDAO>
implements RealmConfigurationStore {
    @Inject
    public RealmConfigurationStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    public RealmConfiguration newEntity() {
        return new RealmConfigurationData();
    }

    @Transactional
    public RealmConfiguration load() {
        return ((RealmConfigurationDAO)this.dao()).get().orElse(null);
    }

    @Transactional
    public void save(RealmConfiguration configuration) {
        this.postCommitEvent(() -> new RealmConfigurationChangedEvent((RealmConfigurationData)configuration));
        ((RealmConfigurationDAO)this.dao()).set((RealmConfigurationData)configuration);
    }
}

