/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.realm;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.security.realm.RealmConfigurationData;
import org.sonatype.nexus.internal.security.realm.RealmConfigurationStoreImpl;
import org.sonatype.nexus.supportzip.ExportSecurityData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="realmConfigurationExport")
@Singleton
public class RealmConfigurationExport
extends JsonExporter
implements ExportSecurityData,
ImportData {
    private final RealmConfigurationStoreImpl configuration;

    @Inject
    public RealmConfigurationExport(RealmConfigurationStoreImpl configuration) {
        this.configuration = configuration;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export RealmConfiguration data to {}", (Object)file);
        this.exportObjectToJson(this.configuration.load(), file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring RealmConfiguration data from {}", (Object)file);
        Optional realmConfiguration = this.importObjectFromJson(file, RealmConfigurationData.class);
        realmConfiguration.ifPresent(this.configuration::save);
    }
}

