/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.util.CollectionUtils;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.model.orient.OrientCPrivilege;
import org.sonatype.nexus.internal.security.model.orient.OrientCPrivilegeEntityAdapter;
import org.sonatype.nexus.internal.security.model.orient.OrientCRole;
import org.sonatype.nexus.internal.security.model.orient.OrientCRoleEntityAdapter;
import org.sonatype.nexus.internal.security.model.orient.OrientCUser;
import org.sonatype.nexus.internal.security.model.orient.OrientCUserEntityAdapter;
import org.sonatype.nexus.internal.security.model.orient.OrientCUserRoleMapping;
import org.sonatype.nexus.internal.security.model.orient.OrientCUserRoleMappingEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.CUser;
import org.sonatype.nexus.security.config.CUserRoleMapping;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfigurationSource;
import org.sonatype.nexus.security.privilege.DuplicatePrivilegeException;
import org.sonatype.nexus.security.privilege.NoSuchPrivilegeException;
import org.sonatype.nexus.security.role.DuplicateRoleException;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.user.NoSuchRoleMappingException;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientSecurityConfigurationSource
extends StateGuardLifecycleSupport
implements SecurityConfigurationSource {
    private final Provider<DatabaseInstance> databaseInstance;
    private final SecurityConfigurationSource securityDefaults;
    private final OrientCUserEntityAdapter userEntityAdapter;
    private final OrientCRoleEntityAdapter roleEntityAdapter;
    private final OrientCPrivilegeEntityAdapter privilegeEntityAdapter;
    private final OrientCUserRoleMappingEntityAdapter userRoleMappingEntityAdapter;
    private SecurityConfiguration configuration;

    @Inject
    public OrientSecurityConfigurationSource(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> databaseInstance, @Named(value="static") @Named(value="static") SecurityConfigurationSource defaults, OrientCUserEntityAdapter userEntityAdapter, OrientCRoleEntityAdapter roleEntityAdapter, OrientCPrivilegeEntityAdapter privilegeEntityAdapter, OrientCUserRoleMappingEntityAdapter userRoleMappingEntityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.securityDefaults = (SecurityConfigurationSource)Preconditions.checkNotNull((Object)defaults);
        this.userEntityAdapter = (OrientCUserEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)userEntityAdapter)));
        this.roleEntityAdapter = (OrientCRoleEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)roleEntityAdapter)));
        this.privilegeEntityAdapter = (OrientCPrivilegeEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)privilegeEntityAdapter)));
        this.userRoleMappingEntityAdapter = (OrientCUserRoleMappingEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)userRoleMappingEntityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.userEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List users = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getUsers();
                    if (users != null && !users.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default users");
                        for (CUser user : users) {
                            OrientSecurityConfigurationSource.this.userEntityAdapter.addEntity(db, (Entity)OrientSecurityConfigurationSource.this.convert(user));
                        }
                    }
                }
            });
            this.roleEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List roles = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getRoles();
                    if (roles != null && !roles.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default roles");
                        for (CRole role : roles) {
                            OrientSecurityConfigurationSource.this.roleEntityAdapter.addEntity(db, (Entity)OrientSecurityConfigurationSource.this.convert(role));
                        }
                    }
                }
            });
            this.privilegeEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List privileges = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getPrivileges();
                    if (privileges != null && !privileges.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default privileges");
                        for (CPrivilege privilege : privileges) {
                            OrientSecurityConfigurationSource.this.privilegeEntityAdapter.addEntity(db, (Entity)OrientSecurityConfigurationSource.this.convert(privilege));
                        }
                    }
                }
            });
            this.userRoleMappingEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List mappings = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getUserRoleMappings();
                    if (mappings != null && !mappings.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default user/role mappings");
                        for (CUserRoleMapping mapping : mappings) {
                            OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.addEntity(db, (Entity)OrientSecurityConfigurationSource.this.convert(mapping));
                        }
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SecurityConfiguration getConfiguration() {
        return this.configuration;
    }

    public SecurityConfiguration loadConfiguration() {
        this.configuration = new OrientSecurityConfiguration();
        return this.getConfiguration();
    }

    private OrientCPrivilege convert(CPrivilege privilege) {
        if (privilege instanceof OrientCPrivilege) {
            return (OrientCPrivilege)privilege;
        }
        OrientCPrivilege orientPrivilege = this.privilegeEntityAdapter.newEntity();
        orientPrivilege.setDescription(privilege.getDescription());
        orientPrivilege.setId(privilege.getId());
        orientPrivilege.setName(privilege.getName());
        orientPrivilege.setProperties(privilege.getProperties());
        orientPrivilege.setReadOnly(privilege.isReadOnly());
        orientPrivilege.setType(privilege.getType());
        orientPrivilege.setVersion(privilege.getVersion());
        return orientPrivilege;
    }

    private OrientCRole convert(CRole role) {
        OrientCRole orientRole = this.roleEntityAdapter.newEntity();
        orientRole.setDescription(role.getDescription());
        orientRole.setId(role.getId());
        orientRole.setName(role.getName());
        orientRole.setPrivileges(role.getPrivileges());
        orientRole.setReadOnly(role.isReadOnly());
        orientRole.setRoles(role.getRoles());
        orientRole.setVersion(role.getVersion());
        return orientRole;
    }

    private OrientCUser convert(CUser user) {
        OrientCUser orientUser = this.userEntityAdapter.newEntity();
        orientUser.setEmail(user.getEmail());
        orientUser.setFirstName(user.getFirstName());
        orientUser.setId(user.getId());
        orientUser.setLastName(user.getLastName());
        orientUser.setPassword(user.getPassword());
        orientUser.setStatus(user.getStatus());
        orientUser.setVersion(user.getVersion());
        return orientUser;
    }

    private OrientCUserRoleMapping convert(CUserRoleMapping userRoleMapping) {
        OrientCUserRoleMapping orientUserRoleMapping = this.userRoleMappingEntityAdapter.newEntity();
        orientUserRoleMapping.setRoles(userRoleMapping.getRoles());
        orientUserRoleMapping.setSource(userRoleMapping.getSource());
        orientUserRoleMapping.setUserId(userRoleMapping.getUserId());
        orientUserRoleMapping.setVersion(userRoleMapping.getVersion());
        return orientUserRoleMapping;
    }

    private static void checkPrivilege(CPrivilege privilege) {
        Preconditions.checkArgument((boolean)(privilege instanceof OrientCPrivilege), (Object)("Privilege is not an instance of " + OrientCPrivilege.class.getName()));
    }

    private static void checkRole(CRole role) {
        Preconditions.checkArgument((boolean)(role instanceof OrientCRole), (Object)("Role is not an instance of " + OrientCRole.class.getName()));
    }

    private static void checkUser(CUser user) {
        Preconditions.checkArgument((boolean)(user instanceof OrientCUser), (Object)("User is not an instance of " + OrientCUser.class.getName()));
    }

    private static void checkUserRoleMapping(CUserRoleMapping userRoleMapping) {
        Preconditions.checkArgument((boolean)(userRoleMapping instanceof OrientCUserRoleMapping), (Object)("UserRoleMapping is not an instance of " + OrientCUserRoleMapping.class.getName()));
    }

    private class OrientSecurityConfiguration
    implements SecurityConfiguration {
        private OrientSecurityConfiguration() {
        }

        private ConcurrentModificationException concurrentlyModified(String type, String value, Exception e) {
            throw new ConcurrentModificationException(String.valueOf(type) + " '" + value + "' updated in the meantime", e);
        }

        public List<CUser> getUsers() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all users");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.userEntityAdapter.browse(db)));
        }

        public CUser getUser(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving user: {}", (Object)id);
            return (CUser)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.userEntityAdapter.read(db, id));
        }

        public void addUser(CUser user, Set<String> roles) {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)user.getId());
            OrientSecurityConfigurationSource.checkUser(user);
            OrientSecurityConfigurationSource.this.log.trace("Adding user: {}", (Object)user.getId());
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                OrientSecurityConfigurationSource.this.userEntityAdapter.addEntity(db, (Entity)((OrientCUser)user));
                this.addUserRoleMapping(this.mapping(user.getId(), roles, "default"));
            });
        }

        public void addRoleMapping(String userId, Set<String> roles, String source) {
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> this.addUserRoleMapping(this.mapping(userId, roles, source)));
        }

        public void updateUser(CUser user) throws UserNotFoundException {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)user.getId());
            OrientSecurityConfigurationSource.checkUser(user);
            OrientSecurityConfigurationSource.this.log.trace("Updating user: {}", (Object)user.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(UserNotFoundException.class).run(db -> {
                    OrientCUser existing = OrientSecurityConfigurationSource.this.userEntityAdapter.read(db, user.getId());
                    if (existing == null) {
                        throw new UserNotFoundException(user.getId());
                    }
                    OrientSecurityConfigurationSource.this.userEntityAdapter.update(db, (OrientCUser)user);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("User", user.getId(), (Exception)((Object)e));
            }
        }

        public void updateUser(CUser user, Set<String> roles) throws UserNotFoundException {
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(UserNotFoundException.class).run(db -> {
                    this.updateUser(user);
                    OrientCUserRoleMapping mapping = OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.read(db, user.getId(), "default");
                    if (mapping == null) {
                        this.addUserRoleMapping(this.mapping(user.getId(), roles));
                    } else {
                        try {
                            mapping.setRoles(roles);
                            this.updateUserRoleMapping(mapping);
                        }
                        catch (NoSuchRoleMappingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("User", user.getId(), (Exception)((Object)e));
            }
        }

        public boolean removeUser(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Removing user: {}", (Object)id);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> {
                    if (OrientSecurityConfigurationSource.this.userEntityAdapter.delete(db, id)) {
                        this.removeUserRoleMapping(id, "default");
                        return true;
                    }
                    return false;
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("User", id, (Exception)((Object)e));
            }
        }

        public List<CPrivilege> getPrivileges() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all privileges");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.privilegeEntityAdapter.browse(db)));
        }

        public CPrivilege getPrivilege(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving privilege {}", (Object)id);
            return (CPrivilege)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.privilegeEntityAdapter.read(db, id));
        }

        @Nullable
        public CPrivilege getPrivilegeByName(String name) {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving privilege by name {}", (Object)name);
            return Optional.ofNullable(name).map(n -> (OrientCPrivilege)((Object)((Object)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.privilegeEntityAdapter.readByName(db, (String)n))))).orElse(null);
        }

        public List<CPrivilege> getPrivileges(Set<String> ids) {
            if (CollectionUtils.isEmpty(ids)) {
                return Collections.emptyList();
            }
            OrientSecurityConfigurationSource.this.log.trace("Retrieving privileges {}", ids);
            return (List)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf(OrientSecurityConfigurationSource.this.privilegeEntityAdapter.read(db, ids)));
        }

        public CPrivilege addPrivilege(CPrivilege privilege) {
            Preconditions.checkNotNull((Object)privilege);
            Preconditions.checkNotNull((Object)privilege.getId());
            OrientSecurityConfigurationSource.this.log.trace("Adding privilege: {}", (Object)privilege.getId());
            try {
                OrientCPrivilege persistedPrivilege = OrientSecurityConfigurationSource.this.convert(privilege);
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                    ODocument oDocument = OrientSecurityConfigurationSource.this.privilegeEntityAdapter.addEntity(db, (Entity)persistedPrivilege);
                });
                return persistedPrivilege;
            }
            catch (ORecordDuplicatedException e) {
                throw new DuplicatePrivilegeException(privilege.getId(), (Exception)((Object)e));
            }
        }

        public void updatePrivilege(CPrivilege privilege) {
            Preconditions.checkNotNull((Object)privilege);
            Preconditions.checkNotNull((Object)privilege.getId());
            OrientSecurityConfigurationSource.checkPrivilege(privilege);
            OrientSecurityConfigurationSource.this.log.trace("Updating privilege: {}", (Object)privilege.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                    OrientCPrivilege existing = OrientSecurityConfigurationSource.this.privilegeEntityAdapter.read(db, privilege.getId());
                    if (existing == null) {
                        throw new NoSuchPrivilegeException(privilege.getId());
                    }
                    OrientSecurityConfigurationSource.this.privilegeEntityAdapter.update(db, (OrientCPrivilege)privilege);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("Privilege", privilege.getId(), (Exception)((Object)e));
            }
        }

        public void updatePrivilegeByName(CPrivilege privilege) {
            Preconditions.checkNotNull((Object)privilege);
            Preconditions.checkNotNull((Object)privilege.getName());
            OrientSecurityConfigurationSource.checkPrivilege(privilege);
            OrientSecurityConfigurationSource.this.log.trace("Updating privilege by name: {}", (Object)privilege.getName());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                    boolean exists = Optional.ofNullable(OrientSecurityConfigurationSource.this.privilegeEntityAdapter.readByName(db, privilege.getName())).isPresent();
                    if (!exists) {
                        throw new NoSuchPrivilegeException(privilege.getName());
                    }
                    OrientSecurityConfigurationSource.this.privilegeEntityAdapter.updateByName(db, (OrientCPrivilege)privilege);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("Privilege", privilege.getName(), (Exception)((Object)e));
            }
        }

        public boolean removePrivilege(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Removing privilege: {}", (Object)id);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> {
                    OrientCPrivilege existing = OrientSecurityConfigurationSource.this.privilegeEntityAdapter.read(db, id);
                    if (existing == null) {
                        throw new NoSuchPrivilegeException(id);
                    }
                    return OrientSecurityConfigurationSource.this.privilegeEntityAdapter.delete(db, id);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("Privilege", id, (Exception)((Object)e));
            }
        }

        public boolean removePrivilegeByName(String name) {
            Preconditions.checkNotNull((Object)name);
            OrientSecurityConfigurationSource.this.log.trace("Removing privilege by name: {}", (Object)name);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> {
                    boolean exists = Optional.ofNullable(OrientSecurityConfigurationSource.this.privilegeEntityAdapter.readByName(db, name)).isPresent();
                    if (!exists) {
                        throw new NoSuchPrivilegeException(name);
                    }
                    return OrientSecurityConfigurationSource.this.privilegeEntityAdapter.deleteByName(db, name);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("Privilege", name, (Exception)((Object)e));
            }
        }

        public List<CRole> getRoles() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all roles");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.roleEntityAdapter.browse(db)));
        }

        public CRole getRole(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving role: {}", (Object)id);
            return (CRole)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.roleEntityAdapter.read(db, id));
        }

        public void addRole(CRole role) {
            Preconditions.checkNotNull((Object)role);
            Preconditions.checkNotNull((Object)role.getId());
            OrientSecurityConfigurationSource.checkRole(role);
            OrientSecurityConfigurationSource.this.log.trace("Adding role: {}", (Object)role.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                    if (OrientSecurityConfigurationSource.this.roleEntityAdapter.read(db, role.getId()) != null) {
                        throw new DuplicateRoleException(role.getId());
                    }
                    OrientSecurityConfigurationSource.this.roleEntityAdapter.addEntity(db, (Entity)((OrientCRole)role));
                });
            }
            catch (ORecordDuplicatedException e) {
                throw new DuplicateRoleException(role.getId(), (Throwable)e);
            }
        }

        public void updateRole(CRole role) {
            Preconditions.checkNotNull((Object)role);
            Preconditions.checkNotNull((Object)role.getId());
            OrientSecurityConfigurationSource.checkRole(role);
            OrientSecurityConfigurationSource.this.log.trace("Updating role: {}", (Object)role.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                    OrientCRole existing = OrientSecurityConfigurationSource.this.roleEntityAdapter.read(db, role.getId());
                    if (existing == null) {
                        throw new NoSuchRoleException(role.getId());
                    }
                    if (!Objects.equals(role.getVersion(), existing.getVersion())) {
                        throw this.concurrentlyModified("Role", role.getId(), null);
                    }
                    OrientSecurityConfigurationSource.this.roleEntityAdapter.update(db, (OrientCRole)role);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("Role", role.getId(), (Exception)((Object)e));
            }
        }

        public boolean removeRole(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Removing role: {}", (Object)id);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> {
                    OrientCRole existing = OrientSecurityConfigurationSource.this.roleEntityAdapter.read(db, id);
                    if (existing == null) {
                        throw new NoSuchRoleException(id);
                    }
                    return OrientSecurityConfigurationSource.this.roleEntityAdapter.delete(db, id);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("Role", id, (Exception)((Object)e));
            }
        }

        private OrientCUserRoleMapping mapping(String userId, Set<String> roles) {
            return this.mapping(userId, roles, "default");
        }

        private OrientCUserRoleMapping mapping(String userId, Set<String> roles, String source) {
            OrientCUserRoleMapping mapping = new OrientCUserRoleMapping();
            mapping.setUserId(userId);
            mapping.setSource(source);
            mapping.setRoles(roles);
            return mapping;
        }

        public List<CUserRoleMapping> getUserRoleMappings() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all user/role mappings");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.browse(db)));
        }

        public CUserRoleMapping getUserRoleMapping(String userId, String source) {
            Preconditions.checkNotNull((Object)userId);
            Preconditions.checkNotNull((Object)source);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving user/role mappings of: {}/{}", (Object)userId, (Object)source);
            return (CUserRoleMapping)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.read(db, userId, source));
        }

        public void addUserRoleMapping(CUserRoleMapping mapping) {
            Preconditions.checkNotNull((Object)mapping);
            OrientSecurityConfigurationSource.checkUserRoleMapping(mapping);
            Preconditions.checkNotNull((Object)mapping.getUserId());
            Preconditions.checkNotNull((Object)mapping.getSource());
            OrientSecurityConfigurationSource.this.log.trace("Adding user/role mappings for: {}/{}", (Object)mapping.getUserId(), (Object)mapping.getSource());
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                ODocument oDocument = OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.addEntity(db, (Entity)((OrientCUserRoleMapping)mapping));
            });
        }

        public void updateUserRoleMapping(CUserRoleMapping mapping) throws NoSuchRoleMappingException {
            Preconditions.checkNotNull((Object)mapping);
            OrientSecurityConfigurationSource.checkUserRoleMapping(mapping);
            Preconditions.checkNotNull((Object)mapping.getUserId());
            Preconditions.checkNotNull((Object)mapping.getSource());
            OrientSecurityConfigurationSource.this.log.trace("Updating user/role mappings for: {}/{}", (Object)mapping.getUserId(), (Object)mapping.getSource());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(NoSuchRoleMappingException.class).run(db -> {
                    OrientCUserRoleMapping existing = OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.read(db, mapping.getUserId(), mapping.getSource());
                    if (existing == null) {
                        throw new NoSuchRoleMappingException(mapping.getUserId());
                    }
                    if (!Objects.equals(mapping.getVersion(), existing.getVersion())) {
                        throw this.concurrentlyModified("User-role mapping", mapping.getUserId(), null);
                    }
                    OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.update(db, (OrientCUserRoleMapping)mapping);
                });
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("User-role mapping", mapping.getUserId(), (Exception)((Object)e));
            }
        }

        public boolean removeUserRoleMapping(String userId, String source) {
            Preconditions.checkNotNull((Object)userId);
            Preconditions.checkNotNull((Object)source);
            OrientSecurityConfigurationSource.this.log.trace("Removing user/role mappings for: {}/{}", (Object)userId, (Object)source);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.delete(db, userId, source));
            }
            catch (OConcurrentModificationException e) {
                throw this.concurrentlyModified("User-role mapping", userId, (Exception)((Object)e));
            }
        }

        public CRole newRole() {
            return OrientSecurityConfigurationSource.this.roleEntityAdapter.newEntity();
        }

        public CUser newUser() {
            return OrientSecurityConfigurationSource.this.userEntityAdapter.newEntity();
        }

        public CUserRoleMapping newUserRoleMapping() {
            return OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.newEntity();
        }

        public CPrivilege newPrivilege() {
            return OrientSecurityConfigurationSource.this.privilegeEntityAdapter.newEntity();
        }
    }
}

