/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model.orient;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.security.config.CUserRoleMapping;

public class OrientCUserRoleMapping
extends AbstractEntity
implements CUserRoleMapping {
    private Set<String> roles;
    private String source;
    private String userId;
    private String version;

    public void addRole(String string) {
        this.getRoles().add(string);
    }

    public OrientCUserRoleMapping clone() {
        try {
            OrientCUserRoleMapping copy = (OrientCUserRoleMapping)((Object)super.clone());
            if (this.roles != null) {
                copy.roles = Sets.newHashSet(this.roles);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = Sets.newHashSet();
        }
        return this.roles;
    }

    public String getSource() {
        return this.source;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeRole(String string) {
        this.getRoles().remove(string);
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "userId='" + this.userId + '\'' + ", source='" + this.source + '\'' + ", roles=" + this.roles + ", version='" + this.version + '\'' + '}';
    }
}

