/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.internal.security.model.orient.OrientCUser;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;

@Named
@Singleton
public class OrientCUserEntityAdapter
extends IterableEntityAdapter<OrientCUser> {
    private static final String DB_CLASS = new OClassNameBuilder().type("user").build();
    private static final String P_ID = "id";
    private static final String P_FIRST_NAME = "firstName";
    private static final String P_LAST_NAME = "lastName";
    private static final String P_PASSWORD = "password";
    private static final String P_STATUS = "status";
    private static final String P_EMAIL = "email";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private final ReadEntityByPropertyAction<OrientCUser> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final UpdateEntityByPropertyAction<OrientCUser> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});

    public OrientCUserEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_FIRST_NAME, OType.STRING);
        type.createProperty(P_LAST_NAME, OType.STRING);
        type.createProperty(P_PASSWORD, OType.STRING).setNotNull(true);
        type.createProperty(P_STATUS, OType.STRING).setNotNull(true);
        type.createProperty(P_EMAIL, OType.STRING).setNotNull(true);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
    }

    protected OrientCUser newEntity() {
        return new OrientCUser();
    }

    protected void readFields(ODocument document, OrientCUser entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setFirstName((String)document.field(P_FIRST_NAME, OType.STRING));
        entity.setLastName((String)document.field(P_LAST_NAME, OType.STRING));
        entity.setPassword((String)document.field(P_PASSWORD, OType.STRING));
        entity.setStatus((String)document.field(P_STATUS, OType.STRING));
        entity.setEmail((String)document.field(P_EMAIL, OType.STRING));
        entity.setVersion(document.getVersion());
    }

    protected void writeFields(ODocument document, OrientCUser entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_FIRST_NAME, (Object)entity.getFirstName());
        document.field(P_LAST_NAME, (Object)entity.getLastName());
        document.field(P_STATUS, (Object)entity.getStatus());
        document.field(P_EMAIL, (Object)entity.getEmail());
        document.field(P_PASSWORD, (Object)entity.getPassword());
    }

    @Nullable
    public OrientCUser read(ODatabaseDocumentTx db, String id) {
        return (OrientCUser)this.read.execute(db, new Object[]{id});
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean update(ODatabaseDocumentTx db, OrientCUser entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getId()});
    }
}

