/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model.orient;

import com.google.common.collect.Sets;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.internal.security.model.orient.OrientCRole;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;

@Named
@Singleton
public class OrientCRoleEntityAdapter
extends IterableEntityAdapter<OrientCRole> {
    private static final String DB_CLASS = new OClassNameBuilder().type("role").build();
    private static final String P_ID = "id";
    private static final String P_NAME = "name";
    private static final String P_DESCRIPTION = "description";
    private static final String P_PRIVILEGES = "privileges";
    private static final String P_ROLES = "roles";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private final ReadEntityByPropertyAction<OrientCRole> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final UpdateEntityByPropertyAction<OrientCRole> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});

    public OrientCRoleEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setNotNull(true);
        type.createProperty(P_DESCRIPTION, OType.STRING);
        type.createProperty(P_PRIVILEGES, OType.EMBEDDEDSET);
        type.createProperty(P_ROLES, OType.EMBEDDEDSET);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
    }

    protected OrientCRole newEntity() {
        return new OrientCRole();
    }

    protected void readFields(ODocument document, OrientCRole entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setDescription((String)document.field(P_DESCRIPTION, OType.STRING));
        entity.setPrivileges(Sets.newHashSet((Iterable)((Iterable)document.field(P_PRIVILEGES, OType.EMBEDDEDSET))));
        entity.setRoles(Sets.newHashSet((Iterable)((Iterable)document.field(P_ROLES, OType.EMBEDDEDSET))));
        entity.setReadOnly(false);
        entity.setVersion(document.getVersion());
    }

    protected void writeFields(ODocument document, OrientCRole entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_DESCRIPTION, (Object)entity.getDescription());
        document.field(P_PRIVILEGES, entity.getPrivileges());
        document.field(P_ROLES, entity.getRoles());
    }

    @Nullable
    public OrientCRole read(ODatabaseDocumentTx db, String id) {
        return (OrientCRole)this.read.execute(db, new Object[]{id});
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean update(ODatabaseDocumentTx db, OrientCRole entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getId()});
    }
}

