/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model.orient;

import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.internal.security.model.orient.OrientCPrivilege;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntitiesByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;

@Named
@Singleton
public class OrientCPrivilegeEntityAdapter
extends IterableEntityAdapter<OrientCPrivilege> {
    private static final String DB_CLASS = new OClassNameBuilder().type("privilege").build();
    private static final String P_ID = "id";
    private static final String P_NAME = "name";
    private static final String P_DESCRIPTION = "description";
    private static final String P_TYPE = "type";
    private static final String P_PROPERTIES = "properties";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final ReadEntityByPropertyAction<OrientCPrivilege> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final ReadEntityByPropertyAction<OrientCPrivilege> readByName = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    private final ReadEntitiesByPropertyAction<OrientCPrivilege> readEntities = new ReadEntitiesByPropertyAction((EntityAdapter)this, "id");
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final DeleteEntityByPropertyAction deleteByName = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});
    private final UpdateEntityByPropertyAction<OrientCPrivilege> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final UpdateEntityByPropertyAction<OrientCPrivilege> updateByName = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"name"});

    public OrientCPrivilegeEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setNotNull(true);
        type.createProperty(P_DESCRIPTION, OType.STRING);
        type.createProperty(P_TYPE, OType.STRING).setNotNull(true);
        type.createProperty(P_PROPERTIES, OType.EMBEDDEDMAP).setNotNull(true);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    protected OrientCPrivilege newEntity() {
        return new OrientCPrivilege();
    }

    protected void readFields(ODocument document, OrientCPrivilege entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setDescription((String)document.field(P_DESCRIPTION, OType.STRING));
        entity.setType((String)document.field(P_TYPE, OType.STRING));
        entity.setReadOnly(false);
        entity.setProperties(Maps.newHashMap((Map)((Map)document.field(P_PROPERTIES, OType.EMBEDDEDMAP))));
        entity.setVersion(document.getVersion());
    }

    protected void writeFields(ODocument document, OrientCPrivilege entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_DESCRIPTION, (Object)entity.getDescription());
        document.field(P_TYPE, (Object)entity.getType());
        document.field(P_PROPERTIES, entity.getProperties());
    }

    @Nullable
    public OrientCPrivilege read(ODatabaseDocumentTx db, String id) {
        return (OrientCPrivilege)this.read.execute(db, new Object[]{id});
    }

    public OrientCPrivilege readByName(ODatabaseDocumentTx db, String name) {
        return (OrientCPrivilege)this.readByName.execute(db, new Object[]{name});
    }

    public List<OrientCPrivilege> read(ODatabaseDocumentTx db, Set<String> ids) {
        return this.readEntities.execute(db, ids);
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean deleteByName(ODatabaseDocumentTx db, String name) {
        return this.deleteByName.execute(db, new Object[]{name});
    }

    public boolean update(ODatabaseDocumentTx db, OrientCPrivilege entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getId()});
    }

    public boolean updateByName(ODatabaseDocumentTx db, OrientCPrivilege entity) {
        return this.updateByName.execute(db, (Entity)entity, new Object[]{entity.getName()});
    }
}

