/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.util.CollectionUtils;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.api.DataAccess;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.internal.security.model.CPrivilegeDAO;
import org.sonatype.nexus.internal.security.model.CPrivilegeData;
import org.sonatype.nexus.internal.security.model.CRoleDAO;
import org.sonatype.nexus.internal.security.model.CRoleData;
import org.sonatype.nexus.internal.security.model.CUserDAO;
import org.sonatype.nexus.internal.security.model.CUserData;
import org.sonatype.nexus.internal.security.model.CUserRoleMappingDAO;
import org.sonatype.nexus.internal.security.model.CUserRoleMappingData;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.CUser;
import org.sonatype.nexus.security.config.CUserRoleMapping;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.privilege.DuplicatePrivilegeException;
import org.sonatype.nexus.security.privilege.NoSuchPrivilegeException;
import org.sonatype.nexus.security.role.DuplicateRoleException;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.user.DuplicateUserException;
import org.sonatype.nexus.security.user.NoSuchRoleMappingException;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalStore;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="mybatis")
@Singleton
public class SecurityConfigurationImpl
extends StateGuardLifecycleSupport
implements TransactionalStore<DataSession<?>>,
SecurityConfiguration {
    private final DataSessionSupplier sessionSupplier;

    @Inject
    public SecurityConfigurationImpl(DataSessionSupplier sessionSupplier) {
        this.sessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)sessionSupplier);
    }

    public DataSession<?> openSession() {
        return this.sessionSupplier.openSession("nexus");
    }

    private DataSession<?> thisSession() {
        return (DataSession)UnitOfWork.currentSession();
    }

    private <T extends DataAccess> T dao(Class<T> daoClass) {
        return (T)this.thisSession().access(daoClass);
    }

    private CPrivilegeDAO privilegeDAO() {
        return this.dao(CPrivilegeDAO.class);
    }

    private CRoleDAO roleDAO() {
        return this.dao(CRoleDAO.class);
    }

    private CUserDAO userDAO() {
        return this.dao(CUserDAO.class);
    }

    private CUserRoleMappingDAO userRoleMappingDAO() {
        return this.dao(CUserRoleMappingDAO.class);
    }

    @Transactional
    public List<CPrivilege> getPrivileges() {
        return ImmutableList.copyOf((Iterable)this.privilegeDAO().browse());
    }

    @Transactional
    public CPrivilege getPrivilege(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.privilegeDAO().read(id).orElse(null);
    }

    @Nullable
    @Transactional
    public CPrivilege getPrivilegeByName(String name) {
        return Optional.of(name).flatMap(n -> this.privilegeDAO().readByName((String)n)).orElse(null);
    }

    @Transactional
    public List<CPrivilege> getPrivileges(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.privilegeDAO().findByIds(ids);
    }

    @Transactional
    public CPrivilege newPrivilege() {
        return new CPrivilegeData();
    }

    @Transactional
    public CPrivilege addPrivilege(CPrivilege privilege) {
        Preconditions.checkNotNull((Object)privilege);
        try {
            this.privilegeDAO().create(this.convert(privilege));
            return privilege;
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new DuplicatePrivilegeException(privilege.getId());
        }
    }

    @Transactional
    public void updatePrivilege(CPrivilege privilege) {
        Preconditions.checkNotNull((Object)privilege);
        privilege.setVersion(privilege.getVersion() + 1);
        if (!this.privilegeDAO().update(this.convert(privilege))) {
            throw new NoSuchPrivilegeException(privilege.getId());
        }
    }

    @Transactional
    public void updatePrivilegeByName(CPrivilege privilege) {
        Optional.of(privilege).map(p -> {
            p.setVersion(p.getVersion() + 1);
            return p;
        }).filter(p -> this.privilegeDAO().updateByName(this.convert((CPrivilege)p))).orElseThrow(() -> new NoSuchPrivilegeException(privilege.getName()));
    }

    @Transactional
    public boolean removePrivilege(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!this.privilegeDAO().delete(id)) {
            throw new NoSuchPrivilegeException(id);
        }
        return true;
    }

    @Transactional
    public boolean removePrivilegeByName(String name) {
        return Optional.of(name).map(n -> this.privilegeDAO().deleteByName((String)n)).filter(Boolean.TRUE::equals).orElseThrow(() -> new NoSuchPrivilegeException(name));
    }

    @Transactional
    public List<CRole> getRoles() {
        return ImmutableList.copyOf((Iterable)this.roleDAO().browse());
    }

    @Transactional
    public CRole getRole(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.roleDAO().read(id).orElse(null);
    }

    @Transactional
    public CRole newRole() {
        return new CRoleData();
    }

    @Transactional
    public void addRole(CRole role) {
        try {
            this.roleDAO().create(this.convert(role));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new DuplicateRoleException(role.getId());
        }
    }

    @Transactional
    public void updateRole(CRole role) {
        Preconditions.checkNotNull((Object)role);
        role.setVersion(role.getVersion() + 1);
        if (!this.roleDAO().update(this.convert(role))) {
            throw new NoSuchRoleException(role.getId());
        }
    }

    @Transactional
    public boolean removeRole(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!this.roleDAO().delete(id)) {
            throw new NoSuchRoleException(id);
        }
        return true;
    }

    @Transactional
    public List<CUser> getUsers() {
        return ImmutableList.copyOf((Iterable)this.userDAO().browse());
    }

    @Transactional
    public CUser getUser(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.userDAO().read(id).orElse(null);
    }

    @Transactional
    public CUser newUser() {
        return new CUserData();
    }

    @Transactional
    public void addUser(CUser user) {
        Preconditions.checkNotNull((Object)user);
        try {
            this.userDAO().create(this.convert(user));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new DuplicateUserException(user.getId());
        }
    }

    @Transactional
    public void addUser(CUser user, Set<String> roles) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull(roles);
        this.addUser(user);
        this.addRoleMapping(user.getId(), roles, "default");
    }

    @Transactional
    public void addRoleMapping(String userId, Set<String> roles, String source) {
        CUserRoleMappingData mapping = new CUserRoleMappingData();
        mapping.setUserId(userId);
        mapping.setSource(source);
        mapping.setRoles(roles);
        this.userRoleMappingDAO().create(mapping);
    }

    @Transactional
    public void updateUser(CUser user) throws UserNotFoundException {
        Preconditions.checkNotNull((Object)user);
        user.setVersion(user.getVersion() + 1);
        if (!this.userDAO().update(this.convert(user))) {
            throw new UserNotFoundException(user.getId());
        }
    }

    @Transactional
    public void updateUser(CUser user, Set<String> roles) throws UserNotFoundException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull(roles);
        this.updateUser(user);
        Optional<CUserRoleMappingData> existingMapping = this.userRoleMappingDAO().read(user.getId(), "default");
        if (existingMapping.isPresent()) {
            CUserRoleMappingData mapping = existingMapping.get();
            mapping.setRoles(roles);
            this.userRoleMappingDAO().update(mapping);
        } else {
            CUserRoleMappingData mapping = new CUserRoleMappingData();
            mapping.setUserId(user.getId());
            mapping.setSource("default");
            mapping.setRoles(roles);
            this.userRoleMappingDAO().create(mapping);
        }
    }

    @Transactional
    public boolean removeUser(String id) {
        Preconditions.checkNotNull((Object)id);
        if (this.userDAO().delete(id)) {
            this.removeUserRoleMapping(id, "default");
            return true;
        }
        return false;
    }

    @Transactional
    public List<CUserRoleMapping> getUserRoleMappings() {
        return ImmutableList.copyOf(this.userRoleMappingDAO().browse());
    }

    @Transactional
    public CUserRoleMapping getUserRoleMapping(String userId, String source) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)source);
        return this.userRoleMappingDAO().read(userId, source).orElse(null);
    }

    @Transactional
    public CUserRoleMapping newUserRoleMapping() {
        return new CUserRoleMappingData();
    }

    @Transactional
    public void addUserRoleMapping(CUserRoleMapping mapping) {
        Preconditions.checkNotNull((Object)mapping);
        this.userRoleMappingDAO().create(this.convert(mapping));
    }

    @Transactional
    public void updateUserRoleMapping(CUserRoleMapping mapping) throws NoSuchRoleMappingException {
        Preconditions.checkNotNull((Object)mapping);
        if (!this.userRoleMappingDAO().update(this.convert(mapping))) {
            throw new NoSuchRoleMappingException(mapping.getUserId());
        }
    }

    @Transactional
    public boolean removeUserRoleMapping(String userId, String source) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)source);
        return this.userRoleMappingDAO().delete(userId, source);
    }

    private CPrivilegeData convert(CPrivilege privilege) {
        if (privilege instanceof CPrivilegeData) {
            return (CPrivilegeData)privilege;
        }
        CPrivilegeData privilegeData = new CPrivilegeData();
        privilegeData.setId(privilege.getId());
        privilegeData.setVersion(privilege.getVersion());
        privilegeData.setName(privilege.getName());
        privilegeData.setDescription(privilege.getDescription());
        privilegeData.setReadOnly(privilege.isReadOnly());
        privilegeData.setProperties(privilege.getProperties());
        privilegeData.setType(privilege.getType());
        return privilegeData;
    }

    private CRoleData convert(CRole role) {
        if (role instanceof CRoleData) {
            return (CRoleData)role;
        }
        CRoleData roleData = new CRoleData();
        roleData.setId(role.getId());
        roleData.setVersion(role.getVersion());
        roleData.setName(role.getName());
        roleData.setDescription(role.getDescription());
        roleData.setReadOnly(role.isReadOnly());
        roleData.setRoles(role.getRoles());
        roleData.setPrivileges(role.getPrivileges());
        return roleData;
    }

    private CUserData convert(CUser user) {
        if (user instanceof CUserData) {
            return (CUserData)user;
        }
        CUserData userData = new CUserData();
        userData.setId(user.getId());
        userData.setVersion(user.getVersion());
        userData.setFirstName(user.getFirstName());
        userData.setLastName(user.getLastName());
        userData.setEmail(user.getEmail());
        userData.setStatus(user.getStatus());
        userData.setPassword(user.getPassword());
        return userData;
    }

    private CUserRoleMappingData convert(CUserRoleMapping mapping) {
        if (mapping instanceof CUserRoleMappingData) {
            return (CUserRoleMappingData)mapping;
        }
        CUserRoleMappingData mappingData = new CUserRoleMappingData();
        mappingData.setUserId(mapping.getUserId());
        mappingData.setSource(mapping.getSource());
        mappingData.setVersion(mapping.getVersion());
        mappingData.setRoles(mapping.getRoles());
        return mappingData;
    }
}

