/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.security.model.CPrivilegeData;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.supportzip.ExportSecurityData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="privilegeExport")
@Singleton
public class PrivilegeExport
extends JsonExporter
implements ExportSecurityData,
ImportData {
    private final SecurityConfiguration configuration;

    @Inject
    public PrivilegeExport(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export CPrivilege data to {}", (Object)file);
        List cleanupPolicies = this.configuration.getPrivileges();
        this.exportToJson(cleanupPolicies, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring CPrivilege data from {}", (Object)file);
        this.importFromJson(file, CPrivilegeData.class).forEach(arg_0 -> ((SecurityConfiguration)this.configuration).addPrivilege(arg_0));
    }
}

