/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.security.config.CUserRoleMapping;
import org.sonatype.nexus.security.config.SecuritySourceUtil;

public class CUserRoleMappingData
implements CUserRoleMapping {
    private Set<String> roles;
    private String source;
    private String userId;
    private int version = 1;

    public void addRole(String string) {
        this.getRoles().add(string);
    }

    public CUserRoleMappingData clone() {
        try {
            CUserRoleMappingData copy = (CUserRoleMappingData)super.clone();
            if (this.roles != null) {
                copy.roles = Sets.newHashSet(this.roles);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = Sets.newHashSet();
        }
        return this.roles;
    }

    public String getSource() {
        return this.source;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVersion() {
        return Integer.toString(this.version);
    }

    public void removeRole(String string) {
        this.getRoles().remove(string);
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setVersion(String version) {
        this.version = version != null ? Integer.parseInt(version) : 0;
    }

    @JsonIgnore
    @Nullable
    public String getUserLo() {
        return SecuritySourceUtil.isCaseInsensitiveSource((String)this.source) ? Strings2.lower((String)this.userId) : null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "userId='" + this.userId + '\'' + ", source='" + this.source + '\'' + ", roles=" + this.roles + ", version='" + this.version + '\'' + '}';
    }
}

