/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonatype.nexus.common.entity.HasStringId;
import org.sonatype.nexus.security.config.CRole;

public class CRoleData
implements HasStringId,
CRole {
    private String description;
    private String id;
    private String name;
    private Set<String> privileges;
    private boolean readOnly = false;
    private Set<String> roles;
    private int version = 1;

    public void addPrivilege(String string) {
        this.getPrivileges().add(string);
    }

    public void addRole(String string) {
        this.getRoles().add(string);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPrivileges() {
        if (this.privileges == null) {
            this.privileges = Sets.newHashSet();
        }
        return this.privileges;
    }

    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = Sets.newHashSet();
        }
        return this.roles;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void removePrivilege(String string) {
        this.getPrivileges().remove(string);
    }

    public void removeRole(String string) {
        this.getRoles().remove(string);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrivileges(Set<String> privileges) {
        this.privileges = privileges;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setVersion(int version) {
        this.version = Math.max(version, 1);
    }

    public CRoleData clone() {
        try {
            CRoleData copy = (CRoleData)super.clone();
            if (this.privileges != null) {
                copy.privileges = Sets.newHashSet(this.privileges);
            }
            if (this.roles != null) {
                copy.roles = Sets.newHashSet(this.roles);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", privileges=" + this.privileges + ", roles=" + this.roles + ", readOnly=" + this.readOnly + ", version='" + this.version + '\'' + '}';
    }
}

