/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.anonymous.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.internal.security.anonymous.orient.OrientAnonymousConfiguration;
import org.sonatype.nexus.internal.security.anonymous.orient.OrientAnonymousConfigurationCreatedEvent;
import org.sonatype.nexus.internal.security.anonymous.orient.OrientAnonymousConfigurationDeletedEvent;
import org.sonatype.nexus.internal.security.anonymous.orient.OrientAnonymousConfigurationUpdatedEvent;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;

@Named
@Singleton
public class OrientAnonymousConfigurationEntityAdapter
extends SingletonEntityAdapter<OrientAnonymousConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("anonymous").build();
    private static final String P_ENABLED = "enabled";
    private static final String P_USER_ID = "user_id";
    private static final String P_REALM_NAME = "realm_name";

    public OrientAnonymousConfigurationEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ENABLED, OType.BOOLEAN).setMandatory(true).setNotNull(true);
        type.createProperty(P_USER_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_REALM_NAME, OType.STRING).setNotNull(true);
    }

    protected OrientAnonymousConfiguration newEntity() {
        return new OrientAnonymousConfiguration();
    }

    protected void readFields(ODocument document, OrientAnonymousConfiguration entity) {
        boolean enabled = (Boolean)document.field(P_ENABLED, OType.BOOLEAN);
        String userId = (String)document.field(P_USER_ID, OType.STRING);
        String realmName = (String)document.field(P_REALM_NAME, OType.STRING);
        entity.setEnabled(enabled);
        entity.setUserId(userId);
        entity.setRealmName(realmName);
    }

    protected void writeFields(ODocument document, OrientAnonymousConfiguration entity) {
        document.field(P_ENABLED, (Object)entity.isEnabled());
        document.field(P_USER_ID, (Object)entity.getUserId());
        document.field(P_REALM_NAME, (Object)entity.getRealmName());
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        this.log.debug("Emitted {} event with metadata {}", (Object)eventKind, (Object)metadata);
        switch (eventKind) {
            case CREATE: {
                return new OrientAnonymousConfigurationCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new OrientAnonymousConfigurationUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new OrientAnonymousConfigurationDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

