/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.anonymous;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.security.anonymous.AnonymousConfigurationStore;
import org.sonatype.nexus.security.anonymous.AnonymousConfiguration;

@Named(value="memory")
@Singleton
@Priority(value=-2147483648)
@VisibleForTesting
public class MemoryAnonymousConfigurationStore
extends ComponentSupport
implements AnonymousConfigurationStore {
    private AnonymousConfiguration model;

    @Override
    @Nullable
    public synchronized AnonymousConfiguration load() {
        return this.model;
    }

    @Override
    public synchronized void save(AnonymousConfiguration configuration) {
        this.model = (AnonymousConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    @Override
    public AnonymousConfiguration newConfiguration() {
        return new MemoryAnonymousConfiguration();
    }

    private static class MemoryAnonymousConfiguration
    implements AnonymousConfiguration {
        private String realmName;
        private String userId;
        private boolean enabled;

        private MemoryAnonymousConfiguration() {
        }

        public AnonymousConfiguration copy() {
            MemoryAnonymousConfiguration configuration = new MemoryAnonymousConfiguration();
            configuration.setEnabled(this.enabled);
            configuration.setRealmName(this.realmName);
            configuration.setUserId(this.userId);
            return configuration;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public String getUserId() {
            return this.userId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setRealmName(String realmName) {
            this.realmName = realmName;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }
    }
}

