/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class NexusSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    private static final String SETTINGS_DOMAIN = "settings";
    private static final String BUNDLES_DOMAIN = "bundles";
    private static final String SEARCH_DOMAIN = "search";
    private static final String APIKEY_DOMAIN = "apikey";
    public static final String NX_ALL_PRIV_ID = "nx-all";
    public static final String NX_ALL_PRIV_DESCRIPTION = "All permissions";
    public static final String NX_ALL_PATTERN = "nexus:*";
    public static final String NX_SETTINGS_ALL_PRIV_ID = "nx-settings-all";
    public static final String NX_SETTINGS_READ_PRIV_ID = "nx-settings-read";
    public static final String NX_SETTINGS_UPDATE_PRIV_ID = "nx-settings-update";
    public static final String NX_BUNDLES_ALL_PRIV_ID = "nx-bundles-all";
    public static final String NX_BUNDLES_READ_PRIV_ID = "nx-bundles-read";
    public static final String NX_SEARCH_READ_PRIV_ID = "nx-search-read";
    public static final String NX_APIKEY_ALL_PRIV_ID = "nx-apikey-all";
    public static final String NX_APIKEY_ALL_DESCRIPTION = "All permissions for APIKey";
    public static final String NX_PRIVILEGE_DOMAIN = "privileges";
    public static final String NX_PRIVILEGE_PRIV_ID_PREFIX = "nx-privileges";
    public static final String NX_ROLE_DOMAIN = "roles";
    public static final String NX_ROLE_PRIV_ID_PREFIX = "nx-roles";
    public static final String NX_USER_DOMAIN = "users";
    public static final String NX_USER_PRIV_ID_PREFIX = "nx-users";
    public static final String NX_USERCHANGEPW_DOMAIN = "userschangepw";
    public static final String NX_USERCHANGEPW_PRIV_ID = "nx-userschangepw";
    public static final String NX_USERCHANGEPW_PRIV_DESCRIPTION = "Change password permission";
    public static final String NX_UPLOAD_DOMAIN = "component";
    public static final String NX_UPLOAD_PRIV_ID = "nx-component-upload";
    public static final String NX_UPLOAD_PRIV_DESCRIPTION = "Upload component permission";
    public static final String NX_ADMIN_ROLE_DESCRIPTION = "Administrator Role";
    public static final String NX_ANON_ROLE_DESCRIPTION = "Anonymous Role";
    public static final String NX_HEALTHCHECK_READ_PRIV_ID = "nx-healthcheck-read";
    public static final String NX_REPO_VIEW_ALL_BROWSE_PRIV_ID = "nx-repository-view-*-*-browse";
    public static final String NX_REPO_VIEW_ALL_READ_PRIV_ID = "nx-repository-view-*-*-read";

    public MemorySecurityConfiguration getContribution() {
        MemorySecurityConfiguration configuration = new MemorySecurityConfiguration();
        configuration.addPrivilege((CPrivilege)this.createWildcardPrivilege(NX_ALL_PRIV_ID, NX_ALL_PRIV_DESCRIPTION, NX_ALL_PATTERN));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_SETTINGS_ALL_PRIV_ID, "All permissions for " + StringUtils.capitalize((String)SETTINGS_DOMAIN), SETTINGS_DOMAIN, "*"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_SETTINGS_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)SETTINGS_DOMAIN), SETTINGS_DOMAIN, "read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_SETTINGS_UPDATE_PRIV_ID, "Update permission for " + StringUtils.capitalize((String)SETTINGS_DOMAIN), SETTINGS_DOMAIN, "update,read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_BUNDLES_ALL_PRIV_ID, "All permissions for " + StringUtils.capitalize((String)BUNDLES_DOMAIN), BUNDLES_DOMAIN, "*"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_BUNDLES_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)BUNDLES_DOMAIN), BUNDLES_DOMAIN, "read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_SEARCH_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)SEARCH_DOMAIN), SEARCH_DOMAIN, "read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_APIKEY_ALL_PRIV_ID, NX_APIKEY_ALL_DESCRIPTION, APIKEY_DOMAIN, "*"));
        this.createCrudAndAllApplicationPrivileges(NX_PRIVILEGE_PRIV_ID_PREFIX, NX_PRIVILEGE_DOMAIN).forEach(arg_0 -> ((MemorySecurityConfiguration)configuration).addPrivilege(arg_0));
        this.createCrudAndAllApplicationPrivileges(NX_ROLE_PRIV_ID_PREFIX, NX_ROLE_DOMAIN).forEach(arg_0 -> ((MemorySecurityConfiguration)configuration).addPrivilege(arg_0));
        this.createCrudAndAllApplicationPrivileges(NX_USER_PRIV_ID_PREFIX, NX_USER_DOMAIN).forEach(arg_0 -> ((MemorySecurityConfiguration)configuration).addPrivilege(arg_0));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_USERCHANGEPW_PRIV_ID, NX_USERCHANGEPW_PRIV_DESCRIPTION, NX_USERCHANGEPW_DOMAIN, "create,read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(NX_UPLOAD_PRIV_ID, NX_UPLOAD_PRIV_DESCRIPTION, NX_UPLOAD_DOMAIN, "create"));
        configuration.addRole((CRole)this.createRole("nx-admin", "nx-admin", NX_ADMIN_ROLE_DESCRIPTION, new String[]{NX_ALL_PRIV_ID}));
        configuration.addRole((CRole)this.createRole("nx-anonymous", "nx-anonymous", NX_ANON_ROLE_DESCRIPTION, new String[]{NX_SEARCH_READ_PRIV_ID, NX_HEALTHCHECK_READ_PRIV_ID, NX_REPO_VIEW_ALL_BROWSE_PRIV_ID, NX_REPO_VIEW_ALL_READ_PRIV_ID}));
        return configuration;
    }
}

